/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.irp3.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.irp3.client.ClientBootstrapInitializer;
import org.bdware.irp3.client.ClientBootstrapInitializerFactory;
import org.bdware.irp3.client.ClientConfig;
import org.bdware.irp3.client.ClientHandler;
import org.bdware.irp3.client.IrpClient;
import org.bdware.irp3.client.ResultCallback;
import org.bdware.irp3.codec.MessageBody;

public class ClientChannel {
    final Bootstrap b = new Bootstrap();
    private final ClientHandler handler = new ClientHandler();
    static Logger LOGGER = LogManager.getLogger(ClientChannel.class);
    private static final int DefaultTimeout = 5;
    private ClientBootstrapInitializer clientBootstrapInitializer;

    public ClientChannel(ClientConfig config) {
        this.clientBootstrapInitializer = ClientBootstrapInitializerFactory.createServerBootstrapInitializer(config);
        this.clientBootstrapInitializer.init(this.b, this.handler);
    }

    public void sendMessage(MessageBody message, ResultCallback<MessageBody> cb) {
        this.handler.sendMessage(message, cb, 5);
    }

    public MessageBody sendMessageSync(MessageBody msg) {
        return this.sendMessageSync(msg, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageBody sendMessageSync(MessageBody msg, int timeoutInSeconds) {
        SyncCallback rcb = new SyncCallback();
        this.handler.sendMessage(msg, rcb, timeoutInSeconds);
        SyncCallback syncCallback = rcb;
        synchronized (syncCallback) {
            try {
                rcb.wait(timeoutInSeconds * 1000);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (rcb.response == null) {
            return null;
        }
        return rcb.response;
    }

    public void connect(URI uri, IrpClient irpClient) throws URISyntaxException {
        LOGGER.info("[URI Parse]scheme:" + uri.getScheme() + "  host: " + uri.getHost() + "  port: " + uri.getPort());
        try {
            Channel channel = this.b.connect(uri.getHost(), uri.getPort()).sync().channel();
            this.handler.setChannel(channel);
            this.handler.setClient(irpClient);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static class SyncCallback
    implements ResultCallback<MessageBody> {
        private MessageBody response;

        SyncCallback() {
        }

        @Override
        public synchronized void onResult(MessageBody message) {
            this.response = message;
            this.notifyAll();
        }
    }
}

