/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.analysis;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bdware.analysis.AnalysisResult;
import org.bdware.analysis.AnalysisTarget;

public abstract class BreadthFirstSearch<R extends AnalysisResult, T extends AnalysisTarget> {
    public Map<T, AnalysisResult> results = new HashMap<T, AnalysisResult>();
    protected List<T> toAnalysis;

    public abstract R execute(T var1);

    public abstract Collection<T> getSuc(T var1);

    public Map<T, AnalysisResult> analysis() {
        this.results.clear();
        AnalysisTarget current = null;
        for (int i = 0; i < this.toAnalysis.size(); ++i) {
            current = (AnalysisTarget)this.toAnalysis.get(i);
            current.setInList(false);
            AnalysisResult preResult = this.results.get(current);
            R sucResult = this.execute(current);
            if (preResult != null && preResult.covers((AnalysisResult)sucResult)) continue;
            AnalysisResult cloneResult = ((AnalysisResult)sucResult).clone();
            if (cloneResult != null) {
                this.results.put(current, cloneResult);
            }
            Collection<AnalysisTarget> sucs = this.getSuc(current);
            for (AnalysisTarget next : sucs) {
                if (this.toAnalysis.contains(next)) {
                    // empty if block
                }
                if (next.inList()) continue;
                this.toAnalysis.add(next);
                next.setInList(true);
            }
        }
        return this.results;
    }

    public int getListLength() {
        return this.toAnalysis.size();
    }

    public void setToAnalysis(List<T> l) {
        this.toAnalysis = l;
    }
}

