/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.analysis.dynamic;

import com.google.gson.JsonObject;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.sc.util.JsonUtil;

public class ProgramPoint {
    private static final Logger LOGGER = LogManager.getLogger(ProgramPoint.class);
    List<Transaction> trans;
    List<FunctionTx> functionTrans;

    public ProgramPoint(InputStream in) {
        Scanner sc = new Scanner(in);
        this.trans = new ArrayList<Transaction>();
        this.functionTrans = new ArrayList<FunctionTx>();
        Transaction transaction = new Transaction();
        FunctionTx funcTx = new FunctionTx();
        transaction.tmToVal = new HashMap<Integer, List<Integer>>();
        funcTx.ppToVal = new HashMap<String, List<String>>();
        while (sc.hasNextLine()) {
            JsonObject jo;
            String string = sc.nextLine().replace("[ProgramPointCounter]", "");
            LOGGER.debug("[string: ]" + string);
            if (string.contains("ENTER")) {
                String[] strings = string.split("_");
                strings = strings[1].split("[(]");
                System.out.println("[stringsss: ]" + strings[0]);
                funcTx.insert(strings[0], "ENTER");
            }
            if (!string.contains("traceMark") || (jo = JsonUtil.parseStringAsJsonObject(string)).get("traceMark") == null) continue;
            if (jo.get("lval") != null) {
                transaction.insert(jo.get("traceMark").getAsInt(), jo.get("lval").getAsInt());
                transaction.insert(jo.get("traceMark").getAsInt(), jo.get("rval").getAsInt());
                continue;
            }
            transaction.insert(jo.get("traceMark").getAsInt(), jo.get("val").getAsInt());
        }
        LOGGER.info(funcTx.ppToVal);
        LOGGER.info(transaction.tmToVal);
        sc.close();
    }

    static class FunctionTx {
        Map<String, List<String>> ppToVal;

        FunctionTx() {
        }

        public void insert(String functionID, String val) {
            List<Object> ret;
            if (!this.ppToVal.containsKey(functionID)) {
                ret = new ArrayList();
                this.ppToVal.put(functionID, ret);
            } else {
                ret = this.ppToVal.get(functionID);
            }
            ret.add(val);
        }
    }

    static class Transaction {
        Map<Integer, List<Integer>> tmToVal;

        Transaction() {
        }

        public void insert(int traceMark, int val) {
            List<Object> ret;
            if (!this.tmToVal.containsKey(traceMark)) {
                ret = new ArrayList();
                this.tmToVal.put(traceMark, ret);
            } else {
                ret = this.tmToVal.get(traceMark);
            }
            ret.add(val);
        }
    }
}

