/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.db;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class FIFOCache<T, V> {
    Map<T, LinkedList<V>> cache = new HashMap<T, LinkedList<V>>();
    int limit;

    public FIFOCache(int limit) {
        this.limit = limit;
    }

    public void add(T key, V val) {
        LinkedList<Object> list = null;
        if (this.cache.containsKey(key)) {
            list = this.cache.get(key);
        } else {
            list = new LinkedList();
            this.cache.put(key, list);
        }
        list.addFirst(val);
        if (list.size() > this.limit) {
            list.removeLast();
        }
    }

    public LinkedList<V> getValues(T key) {
        return this.cache.get(key);
    }

    public Map<T, LinkedList<V>> getCache() {
        return this.cache;
    }

    public void remove(T key) {
        this.cache.remove(key);
    }

    public void clear() {
        this.cache.clear();
    }
}

