/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.analysis.taint;

import org.bdware.analysis.AnalysisResult;
import org.bdware.analysis.InsnPrinter;
import org.bdware.analysis.taint.TaintConfig;
import org.bdware.analysis.taint.TaintInterpreter;
import org.bdware.analysis.taint.TaintValue;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.Frame;

public class TaintResult
extends AnalysisResult {
    public Frame<TaintValue> frame = new Frame(nLocals, nStack);
    public TaintValue ret = new TaintValue(1);
    public static int nLocals = 0;
    public static int nStack = 0;
    public static InsnPrinter printer = new InsnPrinter(262144, System.out);
    public static TaintInterpreter interpreter = new TaintInterpreter(262144);

    public TaintResult() {
        this.ret.isTainted = 0L;
    }

    @Override
    public AnalysisResult merge(AbstractInsnNode insn) {
        interpreter.setCurrentResult(this);
        try {
            if (TaintConfig.isDebug && insn.getOpcode() >= 0) {
                System.out.println("[TaintResult] frameStatus:" + this.frame2Str());
                insn.accept(printer);
            }
            if (insn.getOpcode() >= 0) {
                this.frame.execute(insn, interpreter);
            }
            if (TaintConfig.isDebug && insn.getOpcode() >= 0) {
                System.out.println("[TaintResult] frameStatus:" + this.frame2Str());
            }
        }
        catch (AnalyzerException e) {
            e.printStackTrace();
        }
        return this;
    }

    @Override
    public void printResult() {
        System.out.println("====" + this.frame2Str() + " Ret:" + this.ret.toString() + "====");
    }

    public String frame2Str() {
        TaintValue t;
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append("Local:");
        for (i = 0; i < this.frame.getLocals(); ++i) {
            t = this.frame.getLocal(i);
            if (t != null) {
                sb.append(t.toString());
                continue;
            }
            sb.append("0--");
        }
        sb.append(" Stack:");
        for (i = 0; i < this.frame.getStackSize(); ++i) {
            t = this.frame.getStack(i);
            if (t != null) {
                sb.append(t.toString());
                continue;
            }
            sb.append("0--");
        }
        return sb.toString();
    }

    private static boolean cover(TaintValue t1, TaintValue t2) {
        return t1 != null && t1.isTainted != 0L && (t2 == null || t1.isTainted != t2.isTainted);
    }

    private static boolean isTainted(TaintValue t1) {
        return t1 != null && t1.isTainted != 0L;
    }

    @Override
    public boolean covers(AnalysisResult result) {
        TaintResult tr = (TaintResult)result;
        boolean ret = this.coversInternal(tr);
        return ret;
    }

    public boolean coversInternal(TaintResult tr) {
        int i;
        for (i = 0; i < this.frame.getLocals() && i < tr.frame.getLocals(); ++i) {
            if (!TaintResult.cover(tr.frame.getLocal(i), this.frame.getLocal(i))) continue;
            return false;
        }
        for (i = this.frame.getLocals(); i < tr.frame.getLocals(); ++i) {
            if (!TaintResult.isTainted(tr.frame.getLocal(i))) continue;
            return false;
        }
        for (i = 0; i < this.frame.getStackSize() && i < tr.frame.getStackSize(); ++i) {
            if (!TaintResult.cover(tr.frame.getStack(i), this.frame.getStack(i))) continue;
            return false;
        }
        for (i = this.frame.getStackSize(); i < tr.frame.getStackSize(); ++i) {
            if (!TaintResult.isTainted(tr.frame.getStack(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void mergeResult(AnalysisResult r) {
        TaintValue t1;
        TaintValue target;
        int i;
        TaintResult from = (TaintResult)r;
        for (i = 0; i < from.frame.getLocals(); ++i) {
            target = from.frame.getLocal(i);
            if (this.frame.getLocals() > i) {
                t1 = this.frame.getLocal(i);
                if (target == null) continue;
                if (t1 == null) {
                    t1 = target.clone();
                    this.frame.setLocal(i, t1);
                    continue;
                }
                t1.merge(target);
                continue;
            }
            this.frame.setLocal(i, target.clone());
        }
        for (i = 0; i < from.frame.getStackSize(); ++i) {
            target = from.frame.getStack(i);
            if (this.frame.getStackSize() > i) {
                t1 = this.frame.getStack(i);
                if (target != null) {
                    if (t1 == null) {
                        t1 = target.clone();
                        this.frame.setStack(i, t1);
                    } else {
                        t1.merge(target);
                    }
                }
                t1.merge(from.frame.getStack(i));
                continue;
            }
            if (target != null) {
                this.frame.push(target.clone());
                continue;
            }
            this.frame.push(new TaintValue(1, 0L));
        }
        this.ret.merge(from.ret);
    }

    @Override
    public AnalysisResult clone() {
        TaintValue t;
        int i;
        TaintResult ret = new TaintResult();
        ret.frame = new Frame<TaintValue>(this.frame);
        for (i = 0; i < ret.frame.getLocals(); ++i) {
            t = ret.frame.getLocal(i);
            if (t == null) continue;
            ret.frame.setLocal(i, t.clone());
        }
        for (i = 0; i < ret.frame.getStackSize(); ++i) {
            t = ret.frame.getStack(i);
            if (t == null) continue;
            ret.frame.setStack(i, t.clone());
        }
        ret.ret = this.ret.clone();
        return ret;
    }
}

