/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.conn;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import org.apache.commons.codec.binary.Base64;

public class ByteUtil {
    public static String byteTo(long size) {
        int i;
        String[] unit = new String[]{"B", "KB", "MB", "GB", "TB"};
        double d = size;
        for (i = 0; i < unit.length - 1 && d > 1024.0; d /= 1024.0, ++i) {
        }
        return String.format("%.2f %s", d, unit[i]);
    }

    public static String encodeBASE64(byte[] array) {
        if (array != null) {
            return Base64.encodeBase64String((byte[])array);
        }
        return null;
    }

    public static byte[] decodeBASE64(String encoded) {
        try {
            return Base64.decodeBase64((String)encoded);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String encodeBASE64(byte[] array, int len) {
        if (len == array.length) {
            return ByteUtil.encodeBASE64(array);
        }
        byte[] copied = new byte[len];
        System.arraycopy(array, 0, copied, 0, len);
        return ByteUtil.encodeBASE64(copied);
    }

    public static int readInt(ByteArrayInputStream bi) {
        int ret = 0;
        ret |= bi.read() & 0xFF;
        ret <<= 8;
        ret |= bi.read() & 0xFF;
        ret <<= 8;
        ret |= bi.read() & 0xFF;
        ret <<= 8;
        return ret |= bi.read() & 0xFF;
    }

    public static void writeInt(ByteArrayOutputStream bo, int i) {
        bo.write(i >> 24 & 0xFF);
        bo.write(i >> 16 & 0xFF);
        bo.write(i >> 8 & 0xFF);
        bo.write(i & 0xFF);
    }

    public static long readLong(ByteArrayInputStream bi) {
        long ret = 0L;
        for (int i = 0; i < 8; ++i) {
            ret <<= 8;
            ret |= (long)(bi.read() & 0xFF);
        }
        return ret;
    }

    public static void writeLong(ByteArrayOutputStream bo, long l) {
        for (int i = 56; i >= 0; i -= 8) {
            bo.write((int)(l >> i) & 0xFF);
        }
    }

    public static byte[] readBytes(ByteArrayInputStream bi, int len) {
        byte[] ret = new byte[len];
        bi.read(ret, 0, len);
        return ret;
    }
}

