/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.db;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.sleepycat.je.DatabaseException;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.sc.Jedion;
import org.bdware.sc.db.CMTables;
import org.bdware.sc.index.TimeSerialIndex;
import org.bdware.sc.util.JsonUtil;

public class TimeDBUtil {
    private static final Logger LOGGER = LogManager.getLogger(TimeDBUtil.class);
    public static TimeDBUtil instance;
    private final Map<String, Jedion> dbLink;
    private final Map<String, TimeSerialIndex> index;
    public String dbPath;
    Random random = new Random();

    public TimeDBUtil(String path) {
        this.dbLink = new HashMap<String, Jedion>();
        this.index = new HashMap<String, TimeSerialIndex>();
        this.dbPath = path;
    }

    public static void setupNC() {
        instance = new TimeDBUtil("./NodeCenterDB");
    }

    public static void setupCM() {
        instance = new TimeDBUtil("./ContractManagerDB");
    }

    private static void deleteJelck(File file) {
        if (file.exists()) {
            LOGGER.trace("delete file" + file.getAbsolutePath() + ": " + file.delete());
        }
    }

    private Jedion getDB(String dbName) {
        if (!this.dbLink.containsKey(dbName)) {
            this.setupDB(dbName);
        }
        return this.dbLink.get(dbName);
    }

    private void setupDB(String dbName) {
        Jedion db = new Jedion(dbName);
        File file = new File(this.dbPath + "/" + dbName);
        File timeIndex = new File(this.dbPath + "/" + dbName + ".timeindex");
        TimeDBUtil.deleteJelck(new File(file, "je.lck"));
        if (!file.exists()) {
            LOGGER.trace("create directory " + file.getAbsolutePath() + ": " + file.mkdirs());
        }
        db.configEnvironment(file);
        db.createDatabase();
        this.dbLink.put(dbName, db);
        this.index.put(dbName, new TimeSerialIndex(timeIndex.getAbsolutePath()));
    }

    public void put(String dbName, String val) {
        Jedion db = this.getDB(dbName);
        TimeSerialIndex index = this.getIndex(dbName);
        long key = this.random.nextLong();
        index.index(key);
        db.writeToDatabase(String.valueOf(key), val, true);
    }

    public JsonArray countInIntreval(String dbName, long start, long interval, long end) {
        TimeSerialIndex index = this.getIndex(dbName);
        long offset = index.findNearest(start);
        JsonArray array = new JsonArray();
        do {
            long offset2 = index.findNearest(start += interval);
            array.add((Number)(offset2 - offset));
            offset = offset2;
        } while (start < end);
        return array;
    }

    public List<String> query(String dbName, long end) {
        ArrayList<String> ret = new ArrayList<String>();
        Jedion db = this.getDB(dbName);
        TimeSerialIndex index = this.getIndex(dbName);
        long size = index.size();
        long offset = index.findNearest(end);
        int len = (int)(size - offset);
        List<Long> data = index.request(offset, len);
        for (Long l : data) {
            try {
                String t = db.readFromDatabase(l.toString());
                if (t.isEmpty()) continue;
                ret.add(t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public String queryDetail(String dbName, String key) {
        try {
            Jedion db = this.getDB(dbName);
            return db.readFromDatabase(key);
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<JsonObject> queryLogBefore(String dbName, long end, String contractName) {
        if (!dbName.equals(CMTables.LocalContractLogDB.toString())) {
            return null;
        }
        ArrayList<JsonObject> ret = new ArrayList<JsonObject>();
        Jedion db = this.getDB(dbName);
        TimeSerialIndex index = this.getIndex(dbName);
        long size = index.size();
        long offset = index.findNearest(end);
        int len = (int)(size - offset);
        List<Long> data = index.request(offset, len);
        for (Long l : data) {
            try {
                String t = db.readFromDatabase(l.toString());
                if (null == t || t.isEmpty()) continue;
                JsonObject jo = JsonUtil.parseStringAsJsonObject(t);
                jo.addProperty("key", l.toString());
                if (!jo.has("contractName") || !jo.get("contractName").getAsString().equals(contractName)) continue;
                ret.add(jo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public List<String> queryWithKey(String dbName, long end) {
        if (!dbName.equals(CMTables.LocalContractLogDB.toString())) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>();
        Jedion db = this.getDB(dbName);
        TimeSerialIndex index = this.getIndex(dbName);
        long size = index.size();
        long offset = index.findNearest(end);
        int len = (int)(size - offset);
        List<Long> data = index.request(offset, len);
        for (Long l : data) {
            try {
                String t = db.readFromDatabase(l.toString());
                if (t == null || t.isEmpty()) continue;
                t = t.substring(0, t.length() - 1);
                t = t + ",\"key\":\"" + l + "\"}";
                ret.add(t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public List<String> querySort(String dbName, long end) {
        if (!(dbName.equals("NC_CMLog") || dbName.equals("NC_NodeLogDB") || dbName.equals(CMTables.LocalNodeLogDB.toString()) || dbName.equals(CMTables.LocalContractLogDB.toString()))) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        Jedion db = this.getDB(dbName);
        TimeSerialIndex index = this.getIndex(dbName);
        long size = index.size();
        long offset = index.findNearest(end);
        int len = (int)(size - offset);
        List<Long> data = index.request(offset, len);
        for (Long l : data) {
            try {
                String t = db.readFromDatabase(l.toString());
                Map data2 = (Map)JsonUtil.fromJson(t, new TypeToken<Map<String, String>>(){}.getType());
                if (data2 == null) continue;
                String action = (String)data2.get("action");
                if (map.containsKey(action)) {
                    int count = (Integer)map.get(action) + 1;
                    map.put(action, count);
                    continue;
                }
                map.put(action, 1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (String key : map.keySet()) {
            ret.add("{\"action\":\"" + key + "\",\"times\":" + map.get(key) + "}");
        }
        return ret;
    }

    public List<String> queryDate(String dbName, long end) {
        if (!(dbName.equals("NC_CMLog") || dbName.equals("NC_NodeLogDB") || dbName.equals(CMTables.LocalNodeLogDB.toString()) || dbName.equals(CMTables.LocalContractLogDB.toString()))) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>();
        Jedion db = this.getDB(dbName);
        TimeSerialIndex index = this.getIndex(dbName);
        long size = index.size();
        long offset = index.findNearest(end);
        int len = (int)(size - offset);
        List<Long> data = index.request(offset, len);
        for (Long l : data) {
            try {
                Map data2 = (Map)JsonUtil.fromJson(db.readFromDatabase(l.toString()), new TypeToken<Map<String, String>>(){}.getType());
                if (data2 == null) continue;
                String date = (String)data2.get("date");
                ret.add(date);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public List<String> queryByOffset(String dbName, int offset, int len) {
        ArrayList<String> ret = new ArrayList<String>();
        Jedion db = this.getDB(dbName);
        TimeSerialIndex index = this.getIndex(dbName);
        List<Long> data = index.request(offset, len);
        for (Long l : data) {
            try {
                String t = db.readFromDatabase(l.toString());
                ret.add(t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public List<JsonObject> queryActionDatePair(String dbName, long end, List<String> category) {
        if (!dbName.equals("NC_CMLog") && !dbName.equals("NC_NodeLogDB")) {
            return null;
        }
        ArrayList<JsonObject> ret = new ArrayList<JsonObject>();
        Jedion db = this.getDB(dbName);
        TimeSerialIndex index = this.getIndex(dbName);
        long size = index.size();
        long offset = index.findNearest(end);
        int len = (int)(size - offset);
        List<Long> data = index.request(offset, len);
        for (Long l : data) {
            try {
                String t = db.readFromDatabase(l.toString());
                JsonObject data2 = JsonUtil.parseStringAsJsonObject(t);
                ret.add(data2);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public List<JsonObject> queryActionDatePair(String dbName, long end) {
        if (!dbName.equals("NC_CMLog") && !dbName.equals("NC_NodeLogDB")) {
            return null;
        }
        ArrayList<JsonObject> ret = new ArrayList<JsonObject>();
        Jedion db = this.getDB(dbName);
        TimeSerialIndex index = this.getIndex(dbName);
        long size = index.size();
        long offset = index.findNearest(end);
        int len = (int)(size - offset);
        List<Long> data = index.request(offset, len);
        for (Long l : data) {
            String t = null;
            try {
                t = db.readFromDatabase(l.toString());
                JsonObject data2 = JsonUtil.parseStringAsJsonObject(t);
                ret.add(data2);
            }
            catch (Exception e) {
                LOGGER.error("parse json error:" + t);
            }
        }
        return ret;
    }

    public String get(String dbName, String key) {
        Jedion db = this.getDB(dbName);
        try {
            return db.readFromDatabase(key);
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return null;
        }
    }

    private TimeSerialIndex getIndex(String dbName) {
        return this.index.get(dbName);
    }

    public long getCount(String dbName) {
        try {
            Jedion db = this.getDB(dbName);
            return db.getCount();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }
}

