/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.event;

import java.io.Serializable;
import org.bdware.sc.bean.SM2Verifiable;

public class REvent
extends SM2Verifiable
implements Serializable {
    private final REventType type;
    private final String topic;
    private final String content;
    private final String requestID;
    private String txHash;
    private String hash;
    private String sender;
    private REventSemantics semantics = REventSemantics.AT_LEAST_ONCE;
    private boolean forward = true;
    private String center;

    public REvent(String topic, REventType type, String content, String requestID) {
        this.topic = topic;
        this.type = type;
        this.content = content;
        this.requestID = requestID;
    }

    public String getTopic() {
        return this.topic;
    }

    public REventType getType() {
        return this.type;
    }

    public String getContent() {
        return this.content;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String getTxHash() {
        return this.txHash;
    }

    public void setTxHash(String txHash) {
        this.txHash = txHash;
    }

    public String getRequestID() {
        return this.requestID;
    }

    public REventSemantics getSemantics() {
        return this.semantics;
    }

    public void setSemantics(REventSemantics semantics) {
        this.semantics = semantics;
    }

    public boolean isForward() {
        return this.forward;
    }

    public void setForward(boolean forward) {
        this.forward = forward;
    }

    public String getCenter() {
        return this.center;
    }

    public void setCenter(String center) {
        this.center = center;
    }

    public void doSignature(String pubKey, String privKey) {
        this.setPublicKey(pubKey);
        this.doSignature(privKey);
    }

    @Override
    public String getPublicKey() {
        return this.sender;
    }

    @Override
    public void setPublicKey(String pubkey) {
        this.sender = pubkey;
    }

    @Override
    public String getContentStr() {
        return String.format("{\"topic\":\"%s\",\"content\":\"%s\",\"type\":\"%s\",\"semantics\":\"%s\",\"requestID\":\"%s\"}", new Object[]{this.topic, this.content, this.type, this.semantics, this.requestID});
    }

    public static enum REventSemantics {
        AT_LEAST_ONCE,
        AT_MOST_ONCE,
        ONLY_ONCE,
        NEED_RETRY;

    }

    public static enum REventType {
        SUBSCRIBE,
        UNSUBSCRIBE,
        PUBLISH,
        PRESUB,
        PREPUB;

    }
}

