/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.analysis.dynamic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.bdware.analysis.BasicBlock;
import org.bdware.analysis.BreadthFirstSearch;
import org.bdware.analysis.OpInfo;
import org.bdware.analysis.dynamic.TracedFile;
import org.bdware.analysis.taint.HeapObject;
import org.bdware.analysis.taint.TaintBB;
import org.bdware.analysis.taint.TaintCFG;
import org.bdware.analysis.taint.TaintResult;
import org.bdware.analysis.taint.TaintValue;
import org.objectweb.asm.Label;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;

public class NaiveDynamicTaintAnalysis
extends BreadthFirstSearch<TaintResult, TaintBB> {
    TaintCFG cfg;
    TracedFile tf;
    public static boolean isDebug = false;
    int count = 0;
    String functionGlobel;
    public static HashMap<String, HashMap<Integer, Integer>> branchCount = new HashMap();
    int traceIfNum = 0;

    public NaiveDynamicTaintAnalysis(TaintCFG cfg, TracedFile tf) {
        this.cfg = cfg;
        this.tf = tf;
        ArrayList<TaintBB> toAnalysis = new ArrayList<TaintBB>();
        MethodNode mn = cfg.getMethodNode();
        String methodDesc = mn.desc;
        methodDesc = methodDesc.replaceAll("\\).*$", ")");
        int pos = 2;
        if (methodDesc.split(";").length == 3) {
            pos = 1;
        }
        TaintBB b = (TaintBB)cfg.getBasicBlockAt(0);
        b.preResult = new TaintResult();
        int arg = cfg.argsLocal();
        b.preResult.frame.setLocal(arg, new TaintValue(1, cfg.taintBits.allocate("arg" + arg)));
        b.preResult.frame.setLocal(0, HeapObject.getRootObject());
        cfg.executeLocal();
        TaintResult.interpreter.setTaintBits(cfg.taintBits);
        this.functionGlobel = cfg.getMethodNode().name;
        branchCount.put(this.functionGlobel, new HashMap());
        toAnalysis.add(b);
        b.setInList(true);
        this.setToAnalysis(toAnalysis);
        if (isDebug) {
            System.out.println("===Method:" + cfg.getMethodNode().name + cfg.getMethodNode().desc);
            System.out.println("===Local:" + cfg.getMethodNode().maxLocals + " " + cfg.getMethodNode().maxStack);
        }
    }

    @Override
    public TaintResult execute(TaintBB t) {
        return t.forwardAnalysis();
    }

    @Override
    public Collection<TaintBB> getSuc(TaintBB t) {
        AbstractInsnNode insn;
        HashSet<BasicBlock> subBlock = new HashSet<BasicBlock>();
        if (t.list.size() > 0 && (insn = t.lastInsn()) != null) {
            OpInfo info = null;
            if (insn.getOpcode() >= 0) {
                info = OpInfo.ops[insn.getOpcode()];
            }
            if (info == null) {
                subBlock.addAll(this.cfg.getSucBlocks(t));
            } else if (info.canThrow()) {
                this.callCount(insn);
                subBlock.add(this.cfg.getBasicBlockAt(t.blockID + 1));
            } else if (OpInfo.ops[insn.getOpcode()].canBranch()) {
                subBlock.clear();
                int block = this.handleBranchCase(subBlock, insn, t);
                subBlock.add(this.cfg.getBasicBlockAt(block));
            } else if (OpInfo.ops[insn.getOpcode()].canSwitch()) {
                subBlock.add(this.cfg.getBasicBlockAt(t.blockID + 1));
            } else {
                subBlock.addAll(this.cfg.getSucBlocks(t));
            }
        }
        HashSet<TaintBB> ret = new HashSet<TaintBB>();
        for (BasicBlock bb : subBlock) {
            TaintBB ntbb = (TaintBB)bb;
            ntbb.preResult.mergeResult(t.sucResult);
            ret.add(ntbb);
        }
        return ret;
    }

    private void callCount(AbstractInsnNode insn) {
        if (insn instanceof InvokeDynamicInsnNode) {
            Object invoke = ((InvokeDynamicInsnNode)insn).bsmArgs[0];
            String functionName = ((InvokeDynamicInsnNode)insn).name;
            if (functionName.contains("traceif")) {
                this.traceIfNum = (Integer)invoke;
                if (branchCount.get(this.functionGlobel).containsKey(this.traceIfNum)) {
                    branchCount.get(this.functionGlobel).put(this.traceIfNum, branchCount.get(this.functionGlobel).get(this.traceIfNum) + 1);
                } else {
                    branchCount.get(this.functionGlobel).put(this.traceIfNum, 1);
                }
            }
        }
    }

    private int handleBranchCase(Set<BasicBlock> subBlock, AbstractInsnNode insn, TaintBB t) {
        int blockid = 0;
        switch (insn.getOpcode()) {
            case 154: {
                int ifneCount = branchCount.get(this.functionGlobel).get(this.traceIfNum);
                if (this.tf.trans.get((int)0).tmToVal.get(this.traceIfNum).get(ifneCount) != 0) {
                    if (insn instanceof JumpInsnNode) {
                        LabelNode jump = ((JumpInsnNode)insn).label;
                        blockid = this.cfg.getBasicBlockByLabel((Label)jump.getLabel()).blockID;
                    }
                } else {
                    blockid = t.blockID + 1;
                }
                return blockid;
            }
            case 153: {
                int ifeqCount = branchCount.get(this.functionGlobel).get(this.traceIfNum);
                if (this.tf.trans.get((int)0).tmToVal.get(this.traceIfNum).get(ifeqCount) == 0) {
                    if (insn instanceof JumpInsnNode) {
                        LabelNode jump = ((JumpInsnNode)insn).label;
                        blockid = this.cfg.getBasicBlockByLabel((Label)jump.getLabel()).blockID;
                    }
                } else {
                    blockid = t.blockID + 1;
                }
                return blockid;
            }
            case 156: {
                int ifgeCount = branchCount.get(this.functionGlobel).get(this.traceIfNum);
                if (this.tf.trans.get((int)0).tmToVal.get(this.traceIfNum).get(ifgeCount) >= 0) {
                    if (insn instanceof JumpInsnNode) {
                        LabelNode jump = ((JumpInsnNode)insn).label;
                        blockid = this.cfg.getBasicBlockByLabel((Label)jump.getLabel()).blockID;
                    }
                } else {
                    blockid = t.blockID + 1;
                }
                return blockid;
            }
            case 158: {
                int ifleCount = branchCount.get(this.functionGlobel).get(this.traceIfNum);
                if (this.tf.trans.get((int)0).tmToVal.get(this.traceIfNum).get(ifleCount) <= 0) {
                    if (insn instanceof JumpInsnNode) {
                        LabelNode jump = ((JumpInsnNode)insn).label;
                        blockid = this.cfg.getBasicBlockByLabel((Label)jump.getLabel()).blockID;
                    }
                } else {
                    blockid = t.blockID + 1;
                }
                return blockid;
            }
            case 155: {
                int ifltCount = branchCount.get(this.functionGlobel).get(this.traceIfNum);
                if (this.tf.trans.get((int)0).tmToVal.get(this.traceIfNum).get(ifltCount) < 0) {
                    if (insn instanceof JumpInsnNode) {
                        LabelNode jump = ((JumpInsnNode)insn).label;
                        blockid = this.cfg.getBasicBlockByLabel((Label)jump.getLabel()).blockID;
                    }
                } else {
                    blockid = t.blockID + 1;
                }
                return blockid;
            }
            case 157: {
                int ifgtCount = branchCount.get(this.functionGlobel).get(this.traceIfNum);
                if (this.tf.trans.get((int)0).tmToVal.get(this.traceIfNum).get(ifgtCount) < 0) {
                    if (insn instanceof JumpInsnNode) {
                        LabelNode jump = ((JumpInsnNode)insn).label;
                        blockid = this.cfg.getBasicBlockByLabel((Label)jump.getLabel()).blockID;
                    }
                } else {
                    blockid = t.blockID + 1;
                }
                return blockid;
            }
            default: {
                break;
            }
            case 167: {
                if (!(insn instanceof JumpInsnNode)) break;
                LabelNode jump = ((JumpInsnNode)insn).label;
                blockid = this.cfg.getBasicBlockByLabel((Label)jump.getLabel()).blockID;
            }
        }
        return blockid;
    }
}

