/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.analysis.taint;

import java.util.List;
import org.bdware.analysis.AnalysisTarget;
import org.bdware.analysis.BasicBlock;
import org.bdware.analysis.taint.TaintConfig;
import org.bdware.analysis.taint.TaintResult;
import org.objectweb.asm.tree.AbstractInsnNode;

public class TaintBB
extends BasicBlock
implements AnalysisTarget {
    boolean inList = false;
    public TaintResult preResult = new TaintResult();
    public TaintResult sucResult = new TaintResult();

    public TaintBB(int id) {
        super(id);
    }

    @Override
    public boolean inList() {
        return this.inList;
    }

    @Override
    public void setInList(boolean b) {
        this.inList = b;
    }

    public String getResult() {
        return this.sucResult.frame2Str() + " Ret:" + this.sucResult.ret.toString();
    }

    public String getResultWithTaintBit() {
        return "Ret:" + this.sucResult.ret.toReadableTaint();
    }

    public TaintResult forwardAnalysis() {
        TaintResult oldSuc = this.sucResult;
        TaintResult currentResult = this.sucResult = (TaintResult)this.preResult.clone();
        List<AbstractInsnNode> insns = this.getInsn();
        if (TaintConfig.isDebug) {
            System.out.println("[TaintBB] Enter B" + this.blockID + ":" + this.getResult() + " size:" + insns.size());
        }
        for (int i = 0; i < insns.size(); ++i) {
            currentResult = (TaintResult)currentResult.merge(insns.get(i));
        }
        currentResult.mergeResult(oldSuc);
        if (TaintConfig.isDebug) {
            System.out.println("[TaintBB] Leave B" + this.blockID + ":" + this.getResult() + " size:" + insns.size());
        }
        return currentResult;
    }

    @Override
    public AbstractInsnNode lastInsn() {
        return (AbstractInsnNode)this.list.get(this.list.size() - 1);
    }

    public AbstractInsnNode firstInsn() {
        return (AbstractInsnNode)this.list.get(0);
    }

    public List<AbstractInsnNode> AllInsn() {
        return this.list;
    }
}

