/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.sc.db.CMTables;
import org.bdware.sc.db.KeyValueDBUtil;
import org.bdware.sc.util.JsonUtil;

public class ContractPort {
    private static final Logger LOGGER = LogManager.getLogger(ContractPort.class);
    private static final String USED_PORTS = "USED_PORTS";
    private final AtomicInteger port;
    private final int beginningPort;
    private final Set<Integer> usedPorts;
    private int CMPort;

    public ContractPort(int startPort) {
        this.port = new AtomicInteger(startPort);
        this.beginningPort = startPort;
        this.usedPorts = new HashSet<Integer>();
    }

    public int getPortAndInc() {
        int portInt = this.port.getAndIncrement();
        if (portInt > 65535) {
            this.port.set(this.beginningPort);
            portInt = this.beginningPort;
        }
        return portInt;
    }

    public void reSetPort(int p) {
        if (p > 65535) {
            this.port.set(this.beginningPort);
        } else {
            this.port.set(p);
        }
    }

    public int getCMPort() {
        return this.CMPort;
    }

    public void setCMPort(int cmPort) {
        this.CMPort = cmPort;
        LOGGER.info("cmPort is set to " + cmPort);
    }

    public void visitReconnectPortRange(PortVisitor v) {
        block6: {
            try {
                int[] usedPorts = JsonUtil.fromJson(KeyValueDBUtil.instance.getValue(CMTables.ContractInfo.toString(), USED_PORTS), int[].class);
                if (null == usedPorts || usedPorts.length == 0) {
                    throw new NullPointerException();
                }
                LOGGER.info("visit CP port in " + Arrays.toString(usedPorts));
                int maxUsedPort = -1;
                for (int port : usedPorts) {
                    if (!v.visit(port)) continue;
                    this.updateUsedPorts(port, true);
                    if (port <= maxUsedPort) continue;
                    maxUsedPort = port;
                }
                if (maxUsedPort <= this.port.get()) break block6;
                this.port.set(maxUsedPort + 1);
            }
            catch (Exception ignored) {
                int port;
                int endPort = this.beginningPort + 30;
                for (port = this.beginningPort; port < endPort; ++port) {
                    if (!v.visit(port)) continue;
                    this.updateUsedPorts(port, true);
                }
                LOGGER.info("visit CP port form 1616 to 1646");
                for (port = 1616; port < 1646; ++port) {
                    if (port >= this.beginningPort && port < endPort || !v.visit(port)) continue;
                    this.updateUsedPorts(port, true);
                }
            }
        }
        this.updateDb();
    }

    public void updateDb(int port, boolean isAdd) {
        this.updateUsedPorts(port, isAdd);
        this.updateDb();
    }

    private void updateUsedPorts(int port, boolean isAdd) {
        if (isAdd) {
            this.usedPorts.add(port);
        } else {
            this.usedPorts.remove(port);
        }
    }

    private synchronized void updateDb() {
        KeyValueDBUtil.instance.setValue(CMTables.ContractInfo.toString(), USED_PORTS, JsonUtil.toJson(this.usedPorts));
    }

    public static interface PortVisitor {
        public boolean visit(int var1);
    }
}

