/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.conn;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.sc.codec.LengthFieldBasedFrameCodec;
import org.bdware.sc.conn.MsgHandler;
import org.bdware.sc.conn.ResultCallback;
import org.bdware.sc.get.GetMessage;

public class ServiceServer
extends Thread {
    public static final ExecutorService executor = new ThreadPoolExecutor(8, 15, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    private static final String TAG = "ServiceServer";
    private static final Logger LOGGER = LogManager.getLogger(ServiceServer.class);
    private final MsgHandler handler;
    public AtomicInteger mainPort;
    boolean ready;

    public ServiceServer(MsgHandler handler, int startPort) {
        this.mainPort = new AtomicInteger(startPort);
        this.ready = false;
        this.handler = handler;
        this.start();
    }

    public int getPort() {
        while (!this.ready) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return this.mainPort.get();
    }

    @Override
    public void run() {
        Channel channel;
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
        ServerBootstrap b = new ServerBootstrap();
        b.option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)b.group((EventLoopGroup)bossGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)100)).option(ChannelOption.SO_REUSEADDR, (Object)false)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel arg0) {
                arg0.pipeline().addLast(new ChannelHandler[]{new LengthFieldBasedFrameCodec()}).addLast(new ChannelHandler[]{new AsyncInboundHandler(ServiceServer.this)});
            }
        });
        while (true) {
            try {
                int port = this.mainPort.get();
                ChannelFuture temp1 = b.bind(port);
                temp1.sync();
                channel = temp1.channel();
                this.ready = true;
            }
            catch (Exception e) {
                LOGGER.debug("port already in used:" + this.mainPort);
                this.mainPort.getAndIncrement();
                continue;
            }
            break;
        }
        System.out.println("ServiceServer mainPort " + this.mainPort);
        try {
            channel.closeFuture().await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void handle(GetMessage message, ResultCallback rc) {
        try {
            this.handler.handle(message, rc);
        }
        catch (Throwable e) {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            e.printStackTrace(new PrintStream(bo));
            rc.onResult("{ \"msg\":\"" + bo + "\"}");
        }
    }

    static class AsyncInboundHandler
    extends SimpleChannelInboundHandler<ByteBuf> {
        ServiceServer serviceServer;

        public AsyncInboundHandler(ServiceServer serviceServer) {
            this.serviceServer = serviceServer;
        }

        protected void channelRead0(final ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
            ObjectInputStream obj = new ObjectInputStream((InputStream)new ByteBufInputStream(msg));
            final long id = obj.readLong();
            GetMessage getMsg = (GetMessage)obj.readObject();
            this.serviceServer.handle(getMsg, new ResultCallback(){

                @Override
                public void onResult(String response) {
                    try {
                        this.writeToChannel(ctx, id, response);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeToChannel(ChannelHandlerContext ctx, long id, String response) throws Exception {
            ByteBuf buf = Unpooled.buffer();
            ObjectOutputStream out = new ObjectOutputStream((OutputStream)new ByteBufOutputStream(buf));
            out.writeLong(id);
            out.writeObject(response);
            ChannelHandlerContext channelHandlerContext = ctx;
            synchronized (channelHandlerContext) {
                ctx.writeAndFlush((Object)buf);
            }
        }
    }
}

