/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.conn;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.sc.ContractResult;
import org.bdware.sc.codec.LengthFieldBasedFrameCodec;
import org.bdware.sc.conn.ResultCallback;
import org.bdware.sc.conn.SyncResult;
import org.bdware.sc.get.GetMessage;
import org.bdware.sc.util.JsonUtil;

public class SocketGet {
    private static final Logger LOGGER = LogManager.getLogger(SocketGet.class);
    static EventLoopGroup group = new NioEventLoopGroup(8);
    private final String ipAddress;
    private final int port;
    AtomicInteger i = new AtomicInteger(0);
    Channel channel;
    Bootstrap b;
    SyncResult r = new SyncResult();
    Random random = new Random();
    OfflineHandler offlineExceptionHandler;

    public SocketGet(String ipAddress, int port) {
        this.ipAddress = ipAddress;
        this.port = port;
        this.b = new Bootstrap();
        this.b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)5000);
        this.b.group(group);
        ((Bootstrap)((Bootstrap)this.b.channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                ChannelPipeline p = ch.pipeline();
                p.addLast(new ChannelHandler[]{new LengthFieldBasedFrameCodec()}).addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<ByteBuf>(){

                    protected void channelRead0(ChannelHandlerContext arg0, ByteBuf arg1) throws Exception {
                        ObjectInputStream in = new ObjectInputStream((InputStream)new ByteBufInputStream(arg1));
                        long id = in.readLong();
                        String result = (String)in.readObject();
                        SocketGet.this.r.wakeUp(id, result);
                    }

                    public void channelActive(ChannelHandlerContext ctx) {
                    }

                    public void channelInactive(ChannelHandlerContext ctx) {
                        SocketGet.this.channel = null;
                    }

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                        cause.printStackTrace();
                    }
                }});
            }
        });
        try {
            this.channel = this.b.connect(ipAddress, port).sync().channel();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void setOfflineExceptionHandler(OfflineHandler offlineExceptionHandler) {
        this.offlineExceptionHandler = offlineExceptionHandler;
    }

    private ObjectOutputStream request(String pkgName, String method, String arg, long id) throws InterruptedException, IOException {
        if (!this.isAlive()) {
            this.channel = this.b.connect(this.ipAddress, this.port).sync().channel();
        }
        GetMessage msg = new GetMessage(pkgName, method, arg);
        ByteBuf buf = Unpooled.buffer();
        ObjectOutputStream oo = new ObjectOutputStream((OutputStream)new ByteBufOutputStream(buf));
        oo.writeLong(id);
        oo.writeObject(msg);
        this.channel.writeAndFlush((Object)buf);
        return oo;
    }

    public String syncGet(String pkgName, String method, String arg) {
        try {
            long id = this.random.nextLong();
            final ContractResult cr = new ContractResult(ContractResult.Status.Error, (JsonElement)new JsonPrimitive("Timeout!!"));
            ResultCallback cb = new ResultCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onResult(String str) {
                    cr.status = ContractResult.Status.Success;
                    cr.result = null == str ? null : new JsonPrimitive(str);
                    2 var2_2 = this;
                    synchronized (var2_2) {
                        this.notifyAll();
                    }
                }
            };
            if (!this.r.waitObj.containsKey(id)) {
                this.r.waitObj.put(id, cb);
            }
            this.request(pkgName, method, arg, id).close();
            return this.r.syncSleep(id, cr, cb);
        }
        catch (Exception e) {
            e.printStackTrace();
            ContractResult cr = new ContractResult(ContractResult.Status.Error, (JsonElement)new JsonPrimitive("Failed due to Exception:" + e.getMessage()));
            return JsonUtil.toJson(cr);
        }
    }

    public void asyncGet(String pkgName, String method, String arg, ResultCallback cb) {
        block5: {
            try {
                long id = this.random.nextLong();
                if (!this.r.waitObj.containsKey(id) && null != cb) {
                    this.r.waitObj.put(id, cb);
                } else {
                    LOGGER.warn("id conflict! " + id);
                }
                this.r.sleep(id, cb);
                this.request(pkgName, method, arg, id);
            }
            catch (Exception e) {
                e.printStackTrace();
                ContractResult cr = new ContractResult(ContractResult.Status.Error, (JsonElement)new JsonPrimitive(e.getMessage()));
                if (!this.isAlive() && this.offlineExceptionHandler != null) {
                    this.offlineExceptionHandler.onException(this, e);
                    cr.result = new JsonPrimitive("unavailable now try again later, " + e.getMessage());
                }
                if (null == cb) break block5;
                cb.onResult(JsonUtil.toJson(cr));
            }
        }
    }

    public boolean isAlive() {
        return this.channel != null && this.channel.isActive();
    }

    public static abstract class OfflineHandler {
        public abstract void onException(SocketGet var1, Exception var2);
    }
}

