/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.analysis;

import java.io.PrintStream;
import java.util.Map;
import org.bdware.analysis.OpInfo;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class InsnPrinter
extends MethodVisitor {
    PrintStream ps;
    private Map<Label, Integer> labelOrder;

    public InsnPrinter(int api, PrintStream ps) {
        super(api);
        this.ps = ps;
    }

    @Override
    public void visitInsn(int opcode) {
        this.ps.println(OpInfo.ops[opcode].toString());
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        this.ps.println(OpInfo.ops[opcode].toString() + " " + operand);
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        this.ps.println(OpInfo.ops[opcode].toString() + " " + var);
    }

    @Override
    public void visitTypeInsn(int opcode, String type) {
        this.ps.println(OpInfo.ops[opcode].toString() + " " + type);
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.ps.println(OpInfo.ops[opcode].toString() + " " + owner + " " + name + " " + desc);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        this.ps.println(OpInfo.ops[opcode].toString() + " " + owner + " " + name + " " + desc);
    }

    @Override
    public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
        this.ps.println(OpInfo.INVOKEDYNAMIC.toString() + " " + name + " " + desc + " HANDLE:" + bsm.toString() + " " + this.objs2Str(bsmArgs));
    }

    private String objs2Str(Object[] bsmArgs) {
        StringBuilder sb = new StringBuilder();
        for (Object obj : bsmArgs) {
            sb.append(obj.toString()).append(" ");
        }
        return sb.toString();
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        this.ps.println(OpInfo.ops[opcode].toString() + this.getLabelStr(label));
    }

    private String getLabelStr(Label label) {
        return "L" + this.labelOrder.get(label);
    }

    @Override
    public void visitLabel(Label label) {
        this.ps.println("=" + this.getLabelStr(label) + "=");
    }

    @Override
    public void visitLdcInsn(Object cst) {
        this.ps.println("ldc " + cst);
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        this.ps.println("iinc " + var + " " + increment);
    }

    @Override
    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        this.ps.println(OpInfo.TABLESWITCH.toString() + " labels:" + this.getLabelStr(dflt) + " " + this.convertLabels(labels));
    }

    private String convertLabels(Label[] labels) {
        StringBuilder sb = new StringBuilder();
        for (Label l : labels) {
            sb.append(this.getLabelStr(l)).append(" ");
        }
        return sb.toString();
    }

    @Override
    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.ps.println(OpInfo.LOOKUPSWITCH.toString() + " labels:" + this.getLabelStr(dflt) + " " + this.convertLabels(labels));
    }

    @Override
    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.ps.println(OpInfo.MULTIANEWARRAY + " " + desc + " " + dims);
    }

    public void setLabelOrder(Map<Label, Integer> labelOrder) {
        this.labelOrder = labelOrder;
    }
}

