/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.analysis.example;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bdware.analysis.BasicBlock;
import org.bdware.analysis.BreadthFirstSearch;
import org.bdware.analysis.OpInfo;
import org.bdware.analysis.taint.DirectGraphDFS;
import org.bdware.analysis.taint.HeapObject;
import org.bdware.analysis.taint.TaintBB;
import org.bdware.analysis.taint.TaintCFG;
import org.bdware.analysis.taint.TaintConfig;
import org.bdware.analysis.taint.TaintResult;
import org.bdware.analysis.taint.TaintValue;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;

public class MultiSourceTaintAnalysis
extends BreadthFirstSearch<TaintResult, TaintBB> {
    TaintCFG cfg;

    public MultiSourceTaintAnalysis(TaintCFG cfg) {
        this.cfg = cfg;
        ArrayList<TaintBB> toAnalysis = new ArrayList<TaintBB>();
        TaintBB b = (TaintBB)cfg.getBasicBlockAt(0);
        b.preResult = new TaintResult();
        b.preResult.frame.setLocal(0, HeapObject.getRootObject());
        int arg = cfg.argsLocal();
        b.preResult.frame.setLocal(1, new TaintValue(1, cfg.taintBits.allocate("arg")));
        cfg.executeLocal();
        TaintResult.interpreter.setTaintBits(cfg.taintBits);
        b.preResult.ret = new TaintValue(1);
        TaintResult.printer.setLabelOrder(cfg.getLabelOrder());
        toAnalysis.add(b);
        b.setInList(true);
        this.setToAnalysis(toAnalysis);
        if (TaintConfig.isDebug) {
            System.out.println("===Method:" + cfg.getMethodNode().name + cfg.getMethodNode().desc);
            System.out.println("===Local:" + cfg.getMethodNode().maxLocals + " " + cfg.getMethodNode().maxStack);
        }
    }

    @Override
    public TaintResult execute(TaintBB t) {
        return t.forwardAnalysis();
    }

    @Override
    public Collection<TaintBB> getSuc(TaintBB t) {
        Set<BasicBlock> subBlock = this.cfg.getSucBlocks(t);
        HashSet<TaintBB> ret = new HashSet<TaintBB>();
        for (BasicBlock bb : subBlock) {
            TaintBB ntbb = (TaintBB)bb;
            if (TaintConfig.isDebug) {
                System.out.println("[MultiSoruceTaintAnalysis] B" + ntbb.blockID + " beforeMerge:" + ntbb.preResult.frame2Str());
            }
            ntbb.preResult.mergeResult(t.sucResult);
            if (TaintConfig.isDebug) {
                System.out.println("[MultiSoruceTaintAnalysis] B" + ntbb.blockID + " afterMerge:" + ntbb.preResult.frame2Str());
            }
            ret.add(ntbb);
        }
        return ret;
    }

    public static Map<Integer, List<Integer>> depAnalysis(TaintCFG cfg) {
        HashSet<Integer> depBlocks = new HashSet<Integer>();
        for (BasicBlock b : cfg.getBlocks()) {
            Set<BasicBlock> suc = cfg.getSucBlocks(b);
            int sucSize = suc.size();
            if (sucSize <= 1) continue;
            for (AbstractInsnNode abstractInsnNode : b.getInsn()) {
                if (!(abstractInsnNode instanceof JumpInsnNode)) continue;
                int blockID = b.blockID;
                depBlocks.add(blockID);
            }
        }
        List<BasicBlock> blocks = cfg.getBlocks();
        HashMap map = new HashMap();
        for (BasicBlock bb : blocks) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            Iterator iterator = depBlocks.iterator();
            while (iterator.hasNext()) {
                int id = (Integer)iterator.next();
                Set<BasicBlock> sucBlocks = cfg.getSucBlocks(cfg.getBasicBlockAt(id));
                int sucSize = sucBlocks.size();
                int count = 0;
                for (BasicBlock sucBlock : sucBlocks) {
                    if (!MultiSourceTaintAnalysis.isArrival(cfg, sucBlock, bb)) continue;
                    ++count;
                }
                if (count <= 0 || count == sucSize) continue;
                list.add(id);
            }
            map.put(bb.blockID, list);
        }
        HashMap<Integer, List<Integer>> returnMap = new HashMap<Integer, List<Integer>>();
        for (Map.Entry entry : map.entrySet()) {
            BasicBlock basicBlock = cfg.getBasicBlockAt((Integer)entry.getKey());
            for (AbstractInsnNode an : basicBlock.getInsn()) {
                int opcode;
                if (!(an instanceof InsnNode) || !OpInfo.ops[opcode = an.getOpcode()].canReturn()) continue;
                returnMap.put((Integer)entry.getKey(), (List<Integer>)entry.getValue());
            }
        }
        if (returnMap != null) {
            ArrayList<Integer> lastBlockDep = new ArrayList<Integer>();
            for (Map.Entry entry : returnMap.entrySet()) {
                List listID = (List)entry.getValue();
                for (Integer i : listID) {
                    if (lastBlockDep.contains(i)) continue;
                    lastBlockDep.add(i);
                }
            }
            returnMap.put(cfg.getBasicBlockSize() - 1, lastBlockDep);
        }
        return returnMap;
    }

    public static boolean isArrival(TaintCFG cfg, BasicBlock suc, BasicBlock bb) {
        if (suc.blockID == bb.blockID) {
            return true;
        }
        DirectGraphDFS dgDFS = new DirectGraphDFS(cfg, suc);
        return dgDFS.isArrival(bb);
    }
}

