/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.node;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bdware.sc.bean.JoinInfo;
import org.bdware.sc.bean.RouteInfo;
import org.bdware.sc.node.AnnotationHook;
import org.bdware.sc.node.AnnotationNode;
import org.bdware.sc.node.CostDetail;
import org.bdware.sc.node.LogLocation;
import org.bdware.sc.node.LogType;
import org.bdware.sc.node.Script;
import org.bdware.sc.node.StmtNode;

public class FunctionNode
extends Script {
    private final Set<String> dependentFunctions;
    private final List<AnnotationHook> beforeInvoke;
    private final List<AnnotationHook> afterInvoke;
    public String functionName;
    public List<AnnotationNode> annotations;
    boolean isStatic;
    List<Object> stmts;
    List<String> args;
    String fileName;
    boolean isExport;
    boolean isMask;
    EnumSet<LogType> logTypes;
    LogLocation logLocation = new LogLocation();
    private CostDetail cost;
    private RouteInfo routeInfo;
    private JoinInfo joinInfo;
    private boolean isHandler;
    private boolean isConfidential;
    private boolean isHomomorphicEncrypt;
    private boolean isHomomorphicDecrypt;
    private boolean isView;
    private String keyManagerID;
    private String secretID;
    private JsonElement homoEncryptConf;
    private JsonElement homoDecryptConf;

    public FunctionNode(String name, String fileName) {
        this.functionName = name;
        this.stmts = new ArrayList<Object>();
        this.args = new ArrayList<String>();
        this.fileName = fileName;
        this.isExport = false;
        this.annotations = new ArrayList<AnnotationNode>();
        this.dependentFunctions = new HashSet<String>();
        this.logTypes = EnumSet.noneOf(LogType.class);
        this.isMask = false;
        this.isConfidential = false;
        this.isHomomorphicEncrypt = false;
        this.isHomomorphicDecrypt = false;
        this.isView = false;
        this.keyManagerID = "";
        this.secretID = "";
        this.beforeInvoke = new ArrayList<AnnotationHook>();
        this.afterInvoke = new ArrayList<AnnotationHook>();
    }

    public Set<String> getDependentFunctions() {
        return this.dependentFunctions;
    }

    public void addDependentFunctions(String functionName) {
        this.dependentFunctions.add(functionName);
    }

    public boolean isConfidential() {
        return this.isConfidential;
    }

    public void setConfidential(boolean isConfidential) {
        this.isConfidential = isConfidential;
    }

    public boolean isHandler() {
        return this.isHandler;
    }

    public void setHandler(boolean handler) {
        this.isHandler = handler;
    }

    public CostDetail getCost() {
        return this.cost;
    }

    public void setCost(CostDetail cost) {
        this.cost = cost;
    }

    public void setIsExport(boolean b) {
        this.isExport = b;
    }

    public void setIsMask(boolean b) {
        this.isMask = b;
    }

    public void setStatic(boolean b) {
        this.isStatic = b;
    }

    public void addArg(String arg) {
        this.args.add(arg);
        if (arg.equals("requester")) {
            throw new IllegalArgumentException("The argument shouldn't be requester");
        }
    }

    public void addStmt(StmtNode node) {
        this.stmts.add(node);
    }

    public void addStmts(List<StmtNode> l) {
        this.stmts.addAll(l);
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isExport() {
        return this.isExport;
    }

    public boolean isMask() {
        return this.isMask;
    }

    public void initTextWithRequester() {
        this.plainText = this.args.size() == 0 ? this.plainText.replaceFirst("\\)", "arg, requester, requesterDOI)") : this.plainText.replaceFirst("\\)", ", requester, requesterDOI)");
    }

    public void addAnnotation(AnnotationNode annNode) {
        this.annotations.add(annNode);
    }

    public void addLogType(LogType v) {
        if (v == null) {
            return;
        }
        this.logTypes.add(v);
    }

    public EnumSet<LogType> getLogTypes() {
        return this.logTypes;
    }

    public boolean getLogToBDContract() {
        return this.logLocation.logToBDContract;
    }

    public void setLogToBDContract(boolean b) {
        this.logLocation.logToBDContract = b;
    }

    public boolean getLogToNamedLedger() {
        return this.logLocation.logToNamedLedger;
    }

    public void setLogToNamedLedger(boolean b) {
        this.logLocation.logToNamedLedger = b;
    }

    public void addLedgerName(String name) {
        if (this.logLocation.ledgerNames == null) {
            this.logLocation.ledgerNames = new ArrayList<String>();
        }
        this.logLocation.ledgerNames.add(name);
    }

    public List<String> getLedgerNames() {
        return this.logLocation.ledgerNames;
    }

    public void appendAfterInvokeHandler(AnnotationHook handler) {
        this.afterInvoke.add(handler);
    }

    public List<AnnotationHook> afterExecutionAnnotations() {
        return this.afterInvoke;
    }

    public void appendBeforeInvokeHandler(AnnotationHook handler) {
        this.beforeInvoke.add(handler);
    }

    public List<AnnotationHook> beforeExecutionAnnotations() {
        return this.beforeInvoke;
    }

    public RouteInfo getRouteInfo() {
        return this.routeInfo;
    }

    public void setRouteInfo(RouteInfo routeInfo) {
        this.routeInfo = routeInfo;
    }

    public boolean isHomomorphicEncrypt() {
        return this.isHomomorphicEncrypt;
    }

    public void setHomomorphicEncrypt(boolean isHomomorphicEncrypt) {
        this.isHomomorphicEncrypt = isHomomorphicEncrypt;
    }

    public boolean isHomomorphicDecrypt() {
        return this.isHomomorphicDecrypt;
    }

    public void setHomomorphicDecrypt(boolean isHomomorphicDecrypt) {
        this.isHomomorphicDecrypt = isHomomorphicDecrypt;
    }

    public boolean isView() {
        return this.isView;
    }

    public void setView(boolean view) {
        this.isView = view;
    }

    public String getKeyManagerID() {
        return this.keyManagerID;
    }

    public void setKeyManagerID(String keyManagerID) {
        this.keyManagerID = keyManagerID;
    }

    public String getSecretID() {
        return this.secretID;
    }

    public void setSecretID(String secretID) {
        this.secretID = secretID;
    }

    public JoinInfo getJoinInfo() {
        return this.joinInfo;
    }

    public void setJoinInfo(JoinInfo joinInfo1) {
        this.joinInfo = joinInfo1;
    }

    public JsonElement getHomoEncryptConf() {
        return this.homoEncryptConf;
    }

    public void setHomoEncryptConf(JsonElement homoEncryptConf) {
        this.homoEncryptConf = homoEncryptConf;
    }

    public JsonElement getHomoDecryptConf() {
        return this.homoDecryptConf;
    }

    public void setHomoDecryptConf(JsonElement homoDecryptConf) {
        this.homoDecryptConf = homoDecryptConf;
    }
}

