/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.visitor;

import java.util.ArrayList;
import java.util.List;
import org.bdware.sc.node.AnnotationNode;
import org.bdware.sc.node.ContractNode;
import org.bdware.sc.node.FunctionNode;
import org.bdware.sc.node.ImportNode;
import org.bdware.sc.node.YjsType;
import org.bdware.sc.parser.YJSParser;
import org.bdware.sc.parser.YJSParserBaseVisitor;
import org.bdware.sc.visitor.ClassReader;
import org.bdware.sc.visitor.ContractDependencyVisitor;
import org.bdware.sc.visitor.FunctionDependencyVisitor;
import org.bdware.sc.visitor.FunctionReader;

public class ContractReader
extends YJSParserBaseVisitor<ContractNode> {
    String fileName;

    public ContractReader(String fileName) {
        this.fileName = fileName;
    }

    public static void discoverFunctionDependency(ContractNode node, YJSParser.ContractDeclarContext ctx) {
        List<FunctionNode> functions = node.getFunctions();
        for (FunctionNode f : functions) {
            FunctionDependencyVisitor dependencyVisitor = new FunctionDependencyVisitor(node, f);
            for (YJSParser.ClzOrFunctionDeclarationContext childCtx : ctx.clzOrFunctionDeclaration()) {
                YJSParser.FunctionDeclarationContext fdCtx;
                if (null == childCtx.functionDeclaration() || !f.functionName.equals((fdCtx = childCtx.functionDeclaration()).Identifier().toString())) continue;
                dependencyVisitor.visitFunctionDeclaration(fdCtx);
            }
        }
    }

    public static void discoverContractDependency(ContractNode node, YJSParser.ContractDeclarContext ctx) {
        List<FunctionNode> functions = node.getFunctions();
        for (FunctionNode f : functions) {
            ContractDependencyVisitor dependencyVisitor = new ContractDependencyVisitor(node, f);
            for (YJSParser.ClzOrFunctionDeclarationContext childCtx : ctx.clzOrFunctionDeclaration()) {
                YJSParser.FunctionDeclarationContext fdCtx;
                if (null == childCtx.functionDeclaration() || !f.functionName.equals((fdCtx = childCtx.functionDeclaration()).Identifier().toString())) continue;
                dependencyVisitor.visitFunctionDeclaration(fdCtx);
            }
        }
    }

    @Override
    public ContractNode visitProgram(YJSParser.ProgramContext ctx) {
        List<Object> importStmts = new ArrayList();
        if (null != ctx.importStmts()) {
            importStmts = ctx.importStmts().importStmt();
        }
        YJSParser.ContractDeclarContext contractDelcar = ctx.contractDeclar();
        ContractNode node = new ContractNode(contractDelcar.Identifier().toString());
        for (Object importStmt : importStmts) {
            node.addImportStmt(ImportNode.createFromCtx((YJSParser.ImportStmtContext)((Object)importStmt)));
        }
        List<Object> annotations = new ArrayList();
        if (null != contractDelcar.Oracle()) {
            node.setYjsType(YjsType.Oracle);
        } else if (null != contractDelcar.Contract()) {
            node.setYjsType(YjsType.Contract);
        } else if (null != contractDelcar.Module()) {
            node.setYjsType(YjsType.Module);
        }
        if (null != contractDelcar.annotations()) {
            annotations = contractDelcar.annotations().annotation();
        }
        for (YJSParser.AnnotationContext annotation : annotations) {
            AnnotationNode annNode = new AnnotationNode(annotation.Identifier().toString());
            if (null != annotation.annotationArgs()) {
                for (YJSParser.AnnotationLiteralContext tNode : annotation.annotationArgs().annotationLiteral()) {
                    if (null != tNode.numericLiteral()) {
                        annNode.addArg(tNode.numericLiteral().getText());
                        continue;
                    }
                    if (null != tNode.StringLiteral()) {
                        annNode.addArg(tNode.StringLiteral().getText());
                        continue;
                    }
                    annNode.addArg(tNode.objectLiteral().getText());
                }
            }
            node.addAnnotation(annNode);
        }
        List<YJSParser.ClzOrFunctionDeclarationContext> clzOrFunctions = contractDelcar.clzOrFunctionDeclaration();
        for (YJSParser.ClzOrFunctionDeclarationContext clzOrFunction : clzOrFunctions) {
            YJSParserBaseVisitor reader;
            if (null != clzOrFunction.functionDeclaration()) {
                reader = new FunctionReader(this.fileName);
                node.addFunction(((FunctionReader)reader).visitFunctionDeclaration(clzOrFunction.functionDeclaration()));
                continue;
            }
            if (null != clzOrFunction.classDeclaration()) {
                reader = new ClassReader(this.fileName);
                node.addClass(((ClassReader)reader).visitClassDeclaration(clzOrFunction.classDeclaration()));
                continue;
            }
            if (null == clzOrFunction.eventDeclaration()) continue;
            YJSParser.EventDeclarationContext event = clzOrFunction.eventDeclaration();
            YJSParser.EventSemanticsContext eventSemanticsContext = event.eventSemantics();
            YJSParser.EventGlobalOrLocalContext eventGlobalOrLocalContext = event.eventGlobalOrLocal();
            String semantics = null == eventSemanticsContext ? null : eventSemanticsContext.getText();
            boolean isGlobal = null != eventGlobalOrLocalContext && eventGlobalOrLocalContext.getText().equals("global");
            node.addEvent(event.Identifier().getText(), semantics, isGlobal);
        }
        ContractReader.discoverFunctionDependency(node, contractDelcar);
        ContractReader.discoverContractDependency(node, contractDelcar);
        return node;
    }
}

