/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.commParser.BDLedger;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import org.bdware.sc.commParser.BDLedger.BlockBody;
import org.bdware.sc.commParser.BDLedger.BlockHeader;
import org.bdware.sc.util.HashUtil;
import org.bdware.sc.util.JsonUtil;

public class Block {
    public BlockHeader blockheader;
    public BlockBody blockbody;

    public Block(BlockHeader blockheader, BlockBody blockbody) {
        this.blockheader = blockheader;
        this.blockbody = blockbody;
        System.out.println(this.blockbody);
    }

    public byte[] toByteArray() {
        try {
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            DataOutputStream dd = new DataOutputStream(bo);
            dd.writeInt(this.blockheader.index);
            dd.write(this.blockheader.hash);
            dd.writeInt(this.blockheader.timestamp);
            dd.writeInt(this.blockheader.version);
            dd.write(this.blockheader.prevblockID);
            dd.write(this.blockheader.merkleroot);
            dd.write(this.blockheader.creatorID);
            byte[] bytearr = this.blockbody.toByteArray();
            dd.writeInt(bytearr.length);
            dd.write(bytearr);
            return bo.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String[] getPrevBlockID(byte[] frombytes) {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(frombytes));
        String[] prevBlockID = new String[3];
        byte[] b1 = new byte[20];
        byte[] b2 = new byte[20];
        byte[] b3 = new byte[20];
        try {
            in.read(b1);
            in.read(b2);
            in.read(b3);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        prevBlockID[0] = HashUtil.byteArray2Str(b1);
        prevBlockID[1] = HashUtil.byteArray2Str(b2);
        prevBlockID[2] = HashUtil.byteArray2Str(b3);
        return prevBlockID;
    }

    public String toJson() {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("Index", String.valueOf(this.blockheader.index));
        ret.put("hash", HashUtil.byteArray2Str(this.blockheader.hash));
        ret.put("timestamp", String.valueOf(this.blockheader.timestamp));
        ret.put("version", String.valueOf(this.blockheader.version));
        String[] prevBlockID = this.getPrevBlockID(this.blockheader.prevblockID);
        ret.put("prevblockID", prevBlockID[0] + "," + prevBlockID[1] + "," + prevBlockID[2]);
        ret.put("merkleroot", HashUtil.byteArray2Str(this.blockheader.merkleroot));
        ret.put("creatorID", HashUtil.byteArray2Str(this.blockheader.creatorID));
        return JsonUtil.toJson(ret);
    }
}

