/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.bean;

import com.google.gson.JsonElement;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.HashMap;
import org.bdware.sc.bean.ContractExecType;
import org.bdware.sc.bean.ContractStartInfo;
import org.bdware.sc.bean.SM2Verifiable;
import org.bdware.sc.bean.SerializableJson;
import org.bdware.sc.node.YjsType;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;
import org.zz.gmhelper.SM2Util;

public class Contract
extends SM2Verifiable
implements Serializable {
    public String key;
    public ContractStartInfo startInfo = new ContractStartInfo();
    public int shardingId;
    public String sourcePath;
    public HashMap<String, JsonElement> Mask = new HashMap();
    ContractExecType type;
    String script;
    String owner;
    String pubkey;
    String doi;
    String authInfoPersistDOI;
    String nodeCenterRepoDOI;
    boolean doipFlag;
    int numOfCopies = 1;
    boolean isDebug;
    int consensusType;
    int responseType;
    int networkType;
    long buildTime;
    boolean isConfigUnit;
    private String id;
    private String hash;
    private boolean stateful = true;
    private YjsType yjsType;
    private SerializableJson createParam;

    public int getShardingId() {
        return this.shardingId;
    }

    public void setShardingId(int shardingId) {
        this.shardingId = shardingId;
    }

    public boolean getConfigUnit() {
        return this.isConfigUnit;
    }

    public void setConfigUnit(boolean unit) {
        this.isConfigUnit = unit;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getDOI() {
        return this.doi;
    }

    public void setDOI(String doi) {
        this.doi = doi;
    }

    public String getAuthInfoPersistDOI() {
        return this.authInfoPersistDOI;
    }

    public void setAuthInfoPersistDOI(String authInfoPersistDOI) {
        this.authInfoPersistDOI = authInfoPersistDOI;
    }

    public String getNodeCenterRepoDOI() {
        return this.nodeCenterRepoDOI;
    }

    public void setNodeCenterRepoDOI(String nodeCenterRepoDOI) {
        this.nodeCenterRepoDOI = nodeCenterRepoDOI;
    }

    public boolean getDoipFlag() {
        return this.doipFlag;
    }

    public void setDoipFlag(boolean doipFlag) {
        this.doipFlag = doipFlag;
    }

    public ContractExecType getType() {
        return this.type;
    }

    public void setType(ContractExecType t) {
        this.type = t;
    }

    public InputStream getScript() {
        return new ByteArrayInputStream(this.script.getBytes());
    }

    public void setScript(String str) {
        this.script = str;
    }

    public String getScriptStr() {
        return this.script;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String rsa) {
        this.key = rsa;
    }

    public int getConsensusType() {
        return this.consensusType;
    }

    public void setConsensusType(int i) {
        this.consensusType = i;
    }

    public int getNetworkType() {
        return this.networkType;
    }

    public void setNetworkType(int i) {
        this.networkType = i;
    }

    public int getResponseType() {
        return this.responseType;
    }

    public void setResponseType(int i) {
        this.responseType = i;
    }

    @Override
    public String getPublicKey() {
        return this.pubkey;
    }

    @Override
    public void setPublicKey(String pubkey) {
        this.pubkey = pubkey;
    }

    @Override
    public String getContentStr() {
        return this.type + "|" + this.script + "|" + this.owner;
    }

    public String signResult(String result) {
        ECPrivateKeyParameters priKey = new ECPrivateKeyParameters(new BigInteger(this.key, 16), SM2Util.DOMAIN_PARAMS);
        try {
            return ByteUtils.toHexString((byte[])SM2Util.sign((ECPrivateKeyParameters)priKey, (byte[])result.getBytes()));
        }
        catch (CryptoException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean getStateful() {
        return this.stateful;
    }

    public void setStateful(boolean b) {
        this.stateful = b;
    }

    public int getNumOfCopies() {
        return this.numOfCopies;
    }

    public void setNumOfCopies(int size) {
        this.numOfCopies = size;
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public void setDebug(boolean b) {
        this.isDebug = b;
    }

    public YjsType getYjsType() {
        return this.yjsType;
    }

    public void setYjsType(YjsType yjsType) {
        this.yjsType = yjsType;
    }

    public void setMask(String FunctionName, JsonElement Mask) {
        this.Mask.put(FunctionName, Mask);
    }

    public long getBuildTime() {
        return this.buildTime;
    }

    public void setBuildTime(long buildTime) {
        this.buildTime = buildTime;
    }

    public void setCreateParam(JsonElement ele) {
        this.createParam = new SerializableJson(ele);
    }

    public JsonElement getCreateParam() {
        if (this.createParam != null) {
            return this.createParam.getJsonElement();
        }
        return null;
    }
}

