/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.analysis.taint;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.bdware.analysis.taint.TaintConfig;
import org.bdware.analysis.taint.TaintValue;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;

public class HeapObject
extends TaintValue {
    private Map<String, TaintValue> fields = new HashMap<String, TaintValue>();
    static int allocatID = 0;
    int id = allocatID++;
    private static HashSet<HeapObject> objSet;
    static Map<HeapObject, HeapObject> ccObj;

    public HeapObject() {
        super(1);
    }

    public HeapObject(TaintValue t) {
        this();
        if (t != null) {
            this.merge(t);
            this.size = t.size;
        } else {
            this.isTainted = 0L;
            this.size = 1;
        }
    }

    public static HeapObject getRootObject() {
        HeapObject ret = new HeapObject();
        ret.setProp("Global", new HeapObject());
        ret.setProp("getScope", new HeapObject());
        return ret;
    }

    @Override
    public String toString() {
        return this.countSize() + "|" + super.toString();
    }

    private String countSize() {
        objSet = new HashSet();
        return this.countSizeInternal();
    }

    private String countSizeInternal() {
        if (objSet.contains(this)) {
            return "{H" + this.id + "}";
        }
        objSet.add(this);
        String ret = "{H" + this.id + ",";
        for (String field : this.fields.keySet()) {
            TaintValue tv = this.fields.get(field);
            if (tv instanceof HeapObject) {
                ret = ret + field + ":" + ((HeapObject)tv).countSizeInternal() + ",";
                continue;
            }
            ret = ret + field + ":" + tv.isTainted;
        }
        ret = ret + this.isTainted + "}";
        return ret;
    }

    public static TaintValue operate(AbstractInsnNode insn, List<? extends TaintValue> values, TaintValue calculatedVal) {
        TaintValue retVal = null;
        switch (insn.getOpcode()) {
            case 182: {
                TaintValue tv;
                String desc = ((MethodInsnNode)insn).owner;
                if (!HeapObject.isGetScopeObject((MethodInsnNode)insn) || values.size() == 0 || !((tv = values.get(0)) instanceof HeapObject)) break;
                HeapObject heapObject = (HeapObject)tv;
                retVal = heapObject.getProp("getScope");
                if (retVal == null) {
                    return calculatedVal;
                }
                return retVal;
            }
            case 183: 
            case 184: 
            case 185: {
                break;
            }
            case 186: {
                String desc = ((InvokeDynamicInsnNode)insn).name;
                desc = desc.replaceAll(".*:", "");
                if (HeapObject.isDynGet((InvokeDynamicInsnNode)insn)) {
                    TaintValue tval = values.get(0);
                    if (!(tval instanceof HeapObject)) break;
                    HeapObject heapObject = (HeapObject)tval;
                    retVal = heapObject.getProp(desc);
                    if (retVal != null) {
                        if (TaintConfig.isDebug) {
                            System.out.println("[HeapObject] get:" + desc + " taintVal:" + retVal);
                        }
                        return retVal;
                    }
                    if (TaintConfig.isDebug) {
                        System.out.println("[HeapObject] get:" + desc + " taintVal: empty");
                    }
                    heapObject.setProp(desc, new HeapObject());
                    return heapObject.getProp(desc);
                }
                if (HeapObject.isDynSet((InvokeDynamicInsnNode)insn)) {
                    TaintValue tval;
                    if (TaintConfig.isDebug) {
                        System.out.println("[HeapObject] set:" + desc + " taintVal:" + values.get(1));
                    }
                    if ((tval = values.get(0)) instanceof HeapObject) {
                        HeapObject heapObject = (HeapObject)tval;
                        heapObject.setProp(desc, values.get(1) instanceof HeapObject ? values.get(1) : new HeapObject(values.get(1)));
                        break;
                    }
                    HeapObject heapObject = new HeapObject(tval);
                    heapObject.merge(tval);
                    heapObject.setProp(desc, values.get(1));
                    break;
                }
                for (TaintValue taintValue : values) {
                    if (!(taintValue instanceof HeapObject)) continue;
                    calculatedVal.isTainted |= ((HeapObject)taintValue).wholeTaint();
                }
                break;
            }
        }
        return calculatedVal;
    }

    private static boolean isDynGet(InvokeDynamicInsnNode insn) {
        String desc = insn.name;
        return desc.contains("getProp") && desc.contains("getMethod") && desc.contains("getElem");
    }

    private static boolean isDynSet(InvokeDynamicInsnNode insn) {
        String desc = insn.name;
        return desc.contains("setProp") && desc.contains("setElem");
    }

    private static boolean isGetScopeObject(MethodInsnNode insn) {
        return insn.owner.contains("wrp/jdk/nashorn/internal/runtime/ScriptFunction") && insn.name.equals("getScope");
    }

    public TaintValue getProp(String str) {
        return this.fields.get(str);
    }

    public TaintValue setProp(String str, TaintValue val) {
        return this.fields.put(str, val);
    }

    @Override
    public HeapObject clone() {
        return this;
    }

    public HeapObject actualClone() {
        ccObj = new HashMap<HeapObject, HeapObject>();
        return this.cloneInternal();
    }

    private HeapObject cloneInternal() {
        if (ccObj.containsKey(this)) {
            return ccObj.get(this);
        }
        HeapObject ho = new HeapObject();
        ccObj.put(this, ho);
        ho.isTainted = this.isTainted;
        for (String field : this.fields.keySet()) {
            TaintValue target = this.fields.get(field);
            if (target instanceof HeapObject) {
                ho.fields.put(field, ((HeapObject)target).cloneInternal());
                continue;
            }
            ho.fields.put(field, target.clone());
        }
        return ho;
    }

    public void heapMerge(TaintValue target) {
        this.merge(target);
        if (target instanceof HeapObject) {
            HeapObject targetObject = (HeapObject)target;
            for (String field : targetObject.fields.keySet()) {
                if (this.fields.containsKey(field)) {
                    TaintValue t2 = this.fields.get(field);
                    TaintValue target2 = targetObject.fields.get(field);
                    if (t2 instanceof HeapObject) {
                        ((HeapObject)t2).heapMerge(target2);
                        continue;
                    }
                    if (target2 instanceof HeapObject) {
                        HeapObject next = ((HeapObject)target2).clone();
                        next.merge(t2);
                        this.fields.put(field, next);
                        continue;
                    }
                    t2.merge(target2);
                    continue;
                }
                this.fields.put(field, targetObject.fields.get(field).clone());
            }
        }
    }

    public synchronized long wholeTaint() {
        objSet = new HashSet();
        return this.wholeTaintInternal();
    }

    private long wholeTaintInternal() {
        if (objSet.contains(this)) {
            return 0L;
        }
        objSet.add(this);
        long ret = this.isTainted;
        for (TaintValue tv : this.fields.values()) {
            if (tv instanceof HeapObject) {
                ret |= ((HeapObject)tv).wholeTaintInternal();
                continue;
            }
            ret |= tv.isTainted;
        }
        return ret;
    }
}

