/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.analysis.gas;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bdware.analysis.BasicBlock;
import org.bdware.analysis.CFGraph;
import org.bdware.analysis.OpInfo;
import org.bdware.analysis.gas.FeeSchedule;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;

public class CountProgramPoint {
    public static HashMap<Integer, Map<String, Integer>> ppcount;
    CFGraph actionCfg;
    private String bdName;
    HashMap<String, CFGraph> cfgraphMap;
    String actionName;
    int globalPC;
    Object invoke = 0;

    public CountProgramPoint(HashMap<String, CFGraph> cfgMap, int startPc, int endPc, String aName, HashMap<Integer, Map<String, Integer>> ppc) {
        ppcount = ppc;
        this.cfgraphMap = cfgMap;
        this.actionName = aName;
        this.typeCount(startPc, endPc);
    }

    private HashMap<Integer, Map<String, Integer>> callCount(AbstractInsnNode insn) {
        if (insn instanceof InvokeDynamicInsnNode) {
            this.invoke = ((InvokeDynamicInsnNode)insn).bsmArgs[0];
            String functionName = ((InvokeDynamicInsnNode)insn).name;
            this.dynCount(functionName);
        } else {
            this.normalCount(insn);
        }
        return ppcount;
    }

    public HashMap<Integer, Map<String, Integer>> typeCount(int startPc, int endPc) {
        AbstractInsnNode insnNode;
        BasicBlock bb;
        int j;
        if (startPc == 0) {
            ppcount.put(startPc, new HashMap());
            this.globalPC = startPc;
        } else {
            ppcount.put(endPc, new HashMap());
            this.globalPC = endPc;
        }
        this.actionCfg = this.cfgraphMap.get(this.actionName);
        int blockStart = 0;
        int blockend = 0;
        if (startPc == 0) {
            blockStart = 0;
        } else {
            for (j = 0; j < this.actionCfg.getBasicBlockSize(); ++j) {
                bb = this.actionCfg.getBasicBlockAt(j);
                insnNode = bb.lastInsn();
                if (!(insnNode instanceof InvokeDynamicInsnNode)) continue;
                this.invoke = ((InvokeDynamicInsnNode)insnNode).bsmArgs[0];
                if ((Integer)this.invoke != startPc) continue;
                blockStart = j;
                break;
            }
        }
        for (j = 0; j < this.actionCfg.getBasicBlockSize(); ++j) {
            bb = this.actionCfg.getBasicBlockAt(j);
            insnNode = bb.lastInsn();
            if (!(insnNode instanceof InvokeDynamicInsnNode)) continue;
            this.invoke = ((InvokeDynamicInsnNode)insnNode).bsmArgs[0];
            if ((Integer)this.invoke != endPc) continue;
            blockend = j;
            break;
        }
        return this.getInsn(blockStart, blockend);
    }

    private HashMap<Integer, Map<String, Integer>> getInsn(int blockStart, int blockend) {
        if (blockend == blockStart && blockStart != 0) {
            System.out.println("blockend" + blockend);
            BasicBlock t = this.actionCfg.getBasicBlockAt(blockend);
            if (t.list.size() > 0) {
                List<AbstractInsnNode> insnList = t.getInsn();
                for (AbstractInsnNode insn : insnList) {
                    if (insn instanceof InvokeDynamicInsnNode) {
                        this.callCount(insn);
                        continue;
                    }
                    if (insn instanceof JumpInsnNode) {
                        this.jumpCount(insn);
                        continue;
                    }
                    this.normalCount(insn);
                }
            }
            return ppcount;
        }
        if (blockend == 0) {
            return ppcount;
        }
        if (blockend != blockStart && blockStart != 0) {
            ++blockend;
            System.out.println(++blockStart);
        }
        for (int i = blockStart; i < blockend; ++i) {
            BasicBlock t = this.actionCfg.getBasicBlockAt(i);
            System.out.println("[t.blockID]" + t.blockID);
            if (t.list.size() <= 0) continue;
            List<AbstractInsnNode> insnList = t.getInsn();
            for (AbstractInsnNode insn : insnList) {
                if (insn == null) continue;
                OpInfo info = null;
                if (insn.getOpcode() >= 0) {
                    info = OpInfo.ops[insn.getOpcode()];
                    System.out.println("[info.toString()]" + info.toString());
                }
                if (info == null) continue;
                if (info.canThrow()) {
                    this.callCount(insn);
                    continue;
                }
                if (info.canBranch()) {
                    this.jumpCount(insn);
                    continue;
                }
                if (info.canContinue()) {
                    this.normalCount(insn);
                    continue;
                }
                if (info.canReturn()) {
                    this.normalCount(insn);
                    continue;
                }
                if (info.canSwitch()) {
                    this.normalCount(insn);
                    continue;
                }
                System.out.println("[info:else]" + info);
                this.normalCount(insn);
            }
        }
        return ppcount;
    }

    private void normalCount(AbstractInsnNode insn) {
        this.bdName = FeeSchedule.BDInsn.name();
        if (ppcount.get(this.globalPC).containsKey(this.bdName)) {
            ppcount.get(this.globalPC).put(this.bdName, ppcount.get(this.globalPC).get(this.bdName) + 1);
        } else {
            ppcount.get(this.globalPC).put(this.bdName, 1);
        }
    }

    private void jumpCount(AbstractInsnNode insn) {
        this.bdName = FeeSchedule.BDjump.name();
        if (ppcount.get(this.globalPC).containsKey(this.bdName)) {
            ppcount.get(this.globalPC).put(this.bdName, ppcount.get(this.globalPC).get(this.bdName) + 1);
        } else {
            ppcount.get(this.globalPC).put(this.bdName, 1);
        }
    }

    private void dynCount(String functionName) {
        if (functionName.contains("getProp")) {
            this.bdName = FeeSchedule.BDgetMethod.name();
            if (ppcount.get(this.globalPC).containsKey(this.bdName)) {
                ppcount.get(this.globalPC).put(this.bdName, ppcount.get(this.globalPC).get(this.bdName) + 1);
                System.out.println("   function   " + functionName);
            } else {
                ppcount.get(this.globalPC).put(this.bdName, 1);
            }
        } else if (functionName.contains("setProp")) {
            this.bdName = FeeSchedule.BDsetMethod.name();
            if (ppcount.get(this.globalPC).containsKey(this.bdName)) {
                ppcount.get(this.globalPC).put(this.bdName, ppcount.get(this.globalPC).get(this.bdName) + 1);
                System.out.println("   function   " + functionName);
            } else {
                ppcount.get(this.globalPC).put(this.bdName, 1);
            }
        } else if (functionName.contains("call") && functionName.contains("Util")) {
            this.bdName = FeeSchedule.BDcallUtil.name();
            if (ppcount.get(this.globalPC).containsKey(this.bdName)) {
                ppcount.get(this.globalPC).put(this.bdName, ppcount.get(this.globalPC).get(this.bdName) + 1);
                System.out.println("   function   " + functionName);
            } else {
                ppcount.get(this.globalPC).put(this.bdName, 1);
            }
        } else if (functionName.contains("call") && this.isInnerfunction(functionName)) {
            this.bdName = FeeSchedule.BDcallFuntion.name();
            if (ppcount.get(this.globalPC).containsKey(this.bdName)) {
                ppcount.get(this.globalPC).put(this.bdName, ppcount.get(this.globalPC).get(this.bdName) + 1);
                System.out.println("   function   " + functionName);
            } else {
                ppcount.get(this.globalPC).put(this.bdName, 1);
            }
        } else if (functionName.contains("call")) {
            this.bdName = FeeSchedule.BDcallUtil.name();
            if (ppcount.get(this.globalPC).containsKey(this.bdName)) {
                ppcount.get(this.globalPC).put(this.bdName, ppcount.get(this.globalPC).get(this.bdName) + 1);
                System.out.println("   function   " + functionName);
            } else {
                ppcount.get(this.globalPC).put(this.bdName, 1);
            }
        } else {
            this.bdName = FeeSchedule.BDInsn.name();
            if (ppcount.get(this.globalPC).containsKey(this.bdName)) {
                ppcount.get(this.globalPC).put(this.bdName, ppcount.get(this.globalPC).get(this.bdName) + 1);
            } else {
                ppcount.get(this.globalPC).put(this.bdName, 1);
            }
        }
    }

    private boolean isInnerfunction(String functionName) {
        String string = functionName.split(":")[2];
        return this.cfgraphMap.containsKey(string);
    }
}

