/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.conn;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.sc.conn.Description;
import org.bdware.sc.conn.ResultCallback;
import org.bdware.sc.conn.ServiceServer;
import org.bdware.sc.get.GetMessage;
import org.bdware.sc.util.JsonUtil;

public class MsgHandler {
    private static final Logger LOGGER = LogManager.getLogger(MsgHandler.class);
    Map<String, MethodInfo> methodInfos = new HashMap<String, MethodInfo>();

    public MsgHandler() {
        Class<?> clz = this.getClass();
        for (Method method : clz.getDeclaredMethods()) {
            Description anno = method.getAnnotation(Description.class);
            if (anno == null || method.getParameterCount() != 2) continue;
            this.methodInfos.put(method.getName(), new MethodInfo(method.getName(), anno.value(), method, anno.isAsync()));
        }
    }

    public void handle(GetMessage message, ResultCallback rc) {
        try {
            MethodInfo info = this.methodInfos.get(message.method);
            if (info == null) {
                rc.onResult("{ \"msg\":\"can't handle action:" + message.method + "\"}");
                LOGGER.warn("unsupported action: " + message.method);
            } else if (info.isAsync) {
                ServiceServer.executor.execute(() -> {
                    try {
                        info.m.invoke((Object)this, message, rc);
                    }
                    catch (Exception e) {
                        ByteArrayOutputStream bo = new ByteArrayOutputStream();
                        e.printStackTrace(new PrintStream(bo));
                        rc.onResult("{ \"msg\":\"" + bo + "\"}");
                    }
                });
            } else {
                info.m.invoke((Object)this, message, rc);
            }
        }
        catch (Throwable e) {
            try {
                Method m2 = MsgHandler.class.getDeclaredMethod(message.method, GetMessage.class, ResultCallback.class);
                m2.invoke((Object)this, message, rc);
            }
            catch (Exception e1) {
                ByteArrayOutputStream bo = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(bo));
                rc.onResult("{ \"msg\":\"" + bo + "\"}");
            }
        }
    }

    @Description(value="help info")
    public void help(GetMessage msg, ResultCallback cb) {
        cb.onResult(JsonUtil.toPrettyJson(this.methodInfos));
    }

    static class MethodInfo {
        transient Method m;
        String method;
        String desc;
        boolean isAsync;

        public MethodInfo(String name, String value, Method m, boolean async) {
            this.method = name;
            this.desc = value;
            this.isAsync = async;
            this.m = m;
        }
    }
}

