/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.analysis.taint;

import java.util.Set;
import org.bdware.analysis.BasicBlock;
import org.bdware.analysis.taint.TaintCFG;

public class DirectGraphDFS {
    private boolean[] marked;

    public DirectGraphDFS(TaintCFG cfg, BasicBlock start) {
        this.marked = new boolean[cfg.getBlocks().size()];
        this.dfs(cfg, start);
    }

    private void dfs(TaintCFG cfg, BasicBlock start) {
        this.marked[start.blockID] = true;
        Set<BasicBlock> sucBlocks = cfg.getSucBlocks(start);
        for (BasicBlock bb : sucBlocks) {
            if (this.marked[bb.blockID]) continue;
            this.dfs(cfg, bb);
        }
    }

    public boolean isArrival(BasicBlock end) {
        return this.marked[end.blockID];
    }
}

