/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.db;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.sc.bean.IDSerializable;
import org.bdware.sc.index.TimeSerialIndex;
import org.bdware.sc.util.JsonUtil;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;

public abstract class StatusRecorder<T extends IDSerializable> {
    private static final Logger LOGGER = LogManager.getLogger(StatusRecorder.class);
    private final Map<String, T> status;
    TimeSerialIndex versionIndex;
    RocksDB db;
    String preFix;

    public StatusRecorder(String dirPath, String dbName, String preFix) {
        this.preFix = preFix;
        this.status = new ConcurrentHashMap<String, T>();
        this.versionIndex = new TimeSerialIndex(dirPath + "/" + dbName + ".timeindex");
        this.db = this.setUpDB(new File(dirPath, dbName).getAbsolutePath());
        RocksIterator iter = this.db.newIterator();
        iter.seekToFirst();
        HashSet<String> toRemove = new HashSet<String>();
        while (iter.isValid()) {
            try {
                ObjectInputStream os = new ObjectInputStream(new ByteArrayInputStream(iter.value()));
                IDSerializable meta = (IDSerializable)os.readObject();
                this.status.put(meta.getID(), meta);
            }
            catch (Exception e) {
                e.printStackTrace();
                toRemove.add(new String(iter.key()));
            }
            iter.next();
        }
        try {
            for (String toDelete : toRemove) {
                this.db.delete(toDelete.getBytes());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LOGGER.debug(dbName + " load size:" + this.status.size());
        LOGGER.debug(dbName + " toRemoveKeys:" + JsonUtil.toJson(toRemove));
    }

    private RocksDB setUpDB(String absolutePath) {
        File file = new File(absolutePath);
        Options options = new Options();
        options.setCreateIfMissing(true);
        File lockFile = new File(file, "LOCK");
        RocksDB db = null;
        LOGGER.trace("delete file" + lockFile.getAbsolutePath() + ": " + lockFile.delete());
        try {
            if (!file.exists()) {
                LOGGER.trace("create directory " + file.getAbsolutePath() + ": " + file.mkdirs());
            }
            db = RocksDB.open((Options)options, (String)file.getAbsolutePath());
            return db;
        }
        catch (RocksDBException e) {
            e.printStackTrace();
            return db;
        }
    }

    public synchronized void updateValue(T t) {
        if (null == t) {
            return;
        }
        try {
            this.status.put(t.getID(), t);
            String key = this.preFix + t.getID();
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            ObjectOutputStream oo = new ObjectOutputStream(bo);
            oo.writeObject(t);
            oo.close();
            this.db.put(key.getBytes(), bo.toByteArray());
            this.versionIndex.index(t.getID().hashCode());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void remove(T t) {
        try {
            this.status.remove(t.getID());
            this.db.delete((this.preFix + t.getID()).getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    List<T> getLast(int count) {
        ArrayList<IDSerializable> ret = new ArrayList<IDSerializable>();
        HashSet<Long> set = new HashSet<Long>(this.versionIndex.requestLast(count));
        for (IDSerializable t : this.status.values()) {
            if (null == t || !set.contains(t.getID().hashCode())) continue;
            ret.add(t);
        }
        return ret;
    }

    public long getVersion() {
        return this.versionIndex.size();
    }

    public Map<String, T> getStatus() {
        return this.status;
    }
}

