/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.node;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.runtime.CommonTokenStream;
import org.bdware.sc.event.REvent;
import org.bdware.sc.node.AnnotationNode;
import org.bdware.sc.node.ClassNode;
import org.bdware.sc.node.FunctionNode;
import org.bdware.sc.node.ImportNode;
import org.bdware.sc.node.LogType;
import org.bdware.sc.node.Permission;
import org.bdware.sc.node.YjsType;

public class ContractNode {
    private final List<ImportNode> imports;
    private final List<ClassNode> clzs;
    private final List<FunctionNode> functions;
    private final Map<String, FunctionNode> functionMap;
    private final Set<String> dependentContracts;
    public Map<String, REvent.REventSemantics> events;
    public Map<String, REvent.REventSemantics> logs;
    public List<AnnotationNode> annotations;
    public boolean sigRequired;
    public String memorySet;
    boolean isBundle;
    String contractName;
    List<Permission> permission;
    List<LogType> logTypes;
    YjsType yjsType;
    boolean instrumentBranch;

    public ContractNode(String name) {
        this.contractName = name;
        this.imports = new ArrayList<ImportNode>();
        this.clzs = new ArrayList<ClassNode>();
        this.functions = new ArrayList<FunctionNode>();
        this.functionMap = new HashMap<String, FunctionNode>();
        this.isBundle = false;
        this.events = new HashMap<String, REvent.REventSemantics>();
        this.logs = new HashMap<String, REvent.REventSemantics>();
        this.annotations = new ArrayList<AnnotationNode>();
        this.permission = new ArrayList<Permission>();
        this.instrumentBranch = false;
        this.dependentContracts = new HashSet<String>();
    }

    public void addFunction(FunctionNode function) {
        this.functionMap.put(function.functionName, function);
        this.getFunctions().add(function);
    }

    public void addClass(ClassNode clzNode) {
        this.getClzs().add(clzNode);
    }

    public List<FunctionNode> getFunctions() {
        return this.functions;
    }

    public List<ClassNode> getClzs() {
        return this.clzs;
    }

    public void initPlainText(CommonTokenStream cts) {
        for (ClassNode cn : this.clzs) {
            cn.initText(cts);
        }
        for (FunctionNode fun : this.functions) {
            fun.initTextWithCleaning(cts, fun.isExport, fun.isView());
            if (!fun.isExport && !fun.functionName.equals("onCreate")) continue;
            fun.initTextWithRequester();
        }
    }

    public int queryLine(String methodName) {
        FunctionNode cn = this.functionMap.get(methodName);
        if (null != cn) {
            return cn.getLine();
        }
        return 0;
    }

    public String getContractName() {
        return this.contractName;
    }

    public String queryFile(String methodName) {
        FunctionNode cn = this.functionMap.get(methodName);
        if (null != cn) {
            return cn.getFileName();
        }
        return "--";
    }

    public void addImportStmt(ImportNode importNode) {
        this.imports.add(importNode);
    }

    public List<ImportNode> getImports() {
        return this.imports;
    }

    public boolean isBundle() {
        return this.isBundle;
    }

    public void setIsBundle(boolean b) {
        this.isBundle = b;
    }

    public void merge(ContractNode contract) {
        this.sigRequired |= contract.sigRequired;
        this.instrumentBranch |= contract.instrumentBranch;
        for (FunctionNode fn : contract.functions) {
            this.functions.add(fn);
            this.functionMap.put(fn.functionName, fn);
        }
        this.clzs.addAll(contract.clzs);
        this.events.putAll(contract.events);
        this.logs.putAll(contract.logs);
        if (null != contract.permission) {
            this.permission.addAll(contract.permission);
        }
        if (null != contract.annotations) {
            this.annotations.addAll(contract.annotations);
        }
        this.dependentContracts.addAll(contract.dependentContracts);
    }

    public boolean isExport(String action) {
        FunctionNode node = this.functionMap.get(action);
        return null != node && node.isExport;
    }

    public FunctionNode getFunction(String action) {
        return this.functionMap.get(action);
    }

    public Set<String> getDependentContracts() {
        return this.dependentContracts;
    }

    public void addDependentContracts(String contractName) {
        this.dependentContracts.add(contractName);
    }

    public void addEvent(String eventName, String semantics, boolean isGlobal) {
        Map<String, REvent.REventSemantics> pointer = isGlobal ? this.events : this.logs;
        try {
            pointer.put(eventName, REvent.REventSemantics.valueOf(semantics));
        }
        catch (IllegalArgumentException | NullPointerException e) {
            pointer.put(eventName, REvent.REventSemantics.AT_LEAST_ONCE);
        }
    }

    public void addAnnotation(AnnotationNode annNode) {
        this.annotations.add(annNode);
    }

    public void setLogType(List<String> args) {
        this.logTypes = new ArrayList<LogType>();
        for (String str : args) {
            this.logTypes.add(LogType.parse(str));
        }
    }

    public List<LogType> getLogTypes() {
        return this.logTypes;
    }

    public List<Permission> getPermission() {
        return this.permission;
    }

    public void setPermission(List<String> args) {
        for (String str : args) {
            this.permission.add(Permission.parse(str));
        }
    }

    public YjsType getYjsType() {
        return this.yjsType;
    }

    public void setYjsType(YjsType yjsType1) {
        this.yjsType = yjsType1;
    }

    public boolean getInstrumentBranch() {
        return this.instrumentBranch;
    }

    public void setInstrumentBranch(boolean b) {
        this.instrumentBranch = b;
    }

    public void resetContractName(String name) {
        this.contractName = name;
    }
}

