/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ContractPrinter
extends Thread {
    private static final Logger LOGGER = LogManager.getLogger(ContractPrinter.class);
    private Process p;
    private Scanner sc;
    private String TAG;
    private List<PrintStream> psList;
    private Set<PrintStream> toRemove;

    public void track(Process process, Scanner sc, String tag, PrintStream printStream) {
        this.p = process;
        this.sc = sc;
        this.TAG = tag;
        this.psList = new ArrayList<PrintStream>();
        if (null != printStream) {
            this.psList.add(printStream);
        }
        this.toRemove = new HashSet<PrintStream>();
        this.start();
    }

    public synchronized void redirect(PrintStream ps, String tag) {
        if (null != this.psList && !this.psList.contains(ps)) {
            this.psList.add(ps);
        }
        this.TAG = tag;
    }

    @Override
    public void run() {
        try {
            while (this.sc.hasNextLine()) {
                String content = this.sc.nextLine();
                if (this.psList.size() == 0) {
                    System.out.println(this.TAG + content);
                    continue;
                }
                this.printInList(content);
            }
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage());
        }
    }

    private synchronized void printInList(String content) {
        for (PrintStream ps : this.psList) {
            try {
                ps.println(this.TAG + content);
            }
            catch (Exception e) {
                LOGGER.warn(e.getMessage());
                this.toRemove.add(ps);
            }
        }
        this.psList.removeAll(this.toRemove);
        this.toRemove.clear();
    }
}

