/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.index;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import org.bdware.sc.util.HashUtil;

public class LenVarTimeSerialIndex2 {
    static int chunckSize = 10240;
    public String fileDir;
    public int dataSize = 20;
    public long fileSize = 0L;
    File currentFile;
    RandomAccessFile file;
    byte[] dateBuff = new byte[8];

    public LenVarTimeSerialIndex2(String fileName) {
        File f2 = new File(fileName + ".datasize");
        if (!f2.exists()) {
            throw new IllegalArgumentException("index file don't exists");
        }
        try {
            File f = new File(fileName);
            if (!f.exists()) {
                f.createNewFile();
            }
            this.file = new RandomAccessFile(fileName, "rw");
            this.dataSize = (int)f2.length();
            this.fileSize = this.file.length() / ((long)this.dataSize + 8L);
            this.file.seek(this.fileSize * ((long)this.dataSize + 8L));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static long toDate(byte[] buff) {
        long ret = 0L;
        for (int i = 0; i < 8; ++i) {
            ret <<= 8;
            ret |= (long)(buff[i] & 0xFF);
        }
        return ret;
    }

    protected void finalize() {
        try {
            this.file.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void seek(int pos) {
        try {
            this.file.seek(pos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void manullyIndex(long date, byte[] hash) {
        try {
            if (hash == null || hash.length != this.dataSize) {
                throw new IllegalArgumentException("unsupported data size:" + hash.length);
            }
            ++this.fileSize;
            for (int i = 0; i < 8; ++i) {
                this.dateBuff[i] = (byte)(date >> 56 - i * 8 & 0xFFL);
            }
            this.file.seek(this.file.length());
            this.file.write(this.dateBuff);
            this.file.write(hash);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized long index(byte[] hash) {
        long ret = 0L;
        try {
            if (hash == null || hash.length != this.dataSize) {
                throw new IllegalArgumentException("unsupported data size:" + hash.length);
            }
            ++this.fileSize;
            ret = System.currentTimeMillis();
            for (int i = 0; i < 8; ++i) {
                this.dateBuff[i] = (byte)(ret >> 56 - i * 8 & 0xFFL);
            }
            this.file.seek(this.file.length());
            this.file.write(this.dateBuff);
            this.file.write(hash);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<byte[]> request(long offset, int len) {
        ArrayList<byte[]> ret = new ArrayList<byte[]>();
        if (offset < 0L) {
            offset = 0L;
        }
        if (offset < this.fileSize) {
            long pos = 0L;
            try {
                pos = this.file.getFilePointer();
                this.file.seek(offset * ((long)this.dataSize + 8L));
                while (offset < this.fileSize && len > 0) {
                    byte[] data = new byte[this.dataSize + 8];
                    this.file.read(data);
                    ret.add(data);
                    ++offset;
                    --len;
                }
                this.file.seek(pos);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    this.file.seek(pos);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return ret;
        }
        return new ArrayList<byte[]>();
    }

    public long size() {
        return this.fileSize;
    }

    public synchronized List<byte[]> requestLast(int count) {
        long offset = this.fileSize - (long)count;
        return this.request(offset, count);
    }

    public synchronized List<byte[]> requestByTime(long startTime, long endTime) {
        long start = this.bsearch(0L, this.fileSize, startTime);
        long end = this.bsearch(0L, this.fileSize, endTime);
        return this.request(start, (int)(end - start + 1L));
    }

    private long bsearch(long s, long e, long time) {
        if (e <= s + 1L) {
            return s;
        }
        long offset = (s + e) / 2L;
        try {
            this.file.seek(offset * ((long)this.dataSize + 8L));
            this.file.read(this.dateBuff);
            long date = HashUtil.bytes2Long(this.dateBuff);
            if (date < time) {
                return this.bsearch(offset + 1L, e, time);
            }
            return this.bsearch(s, offset, time);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return -1L;
        }
    }
}

