/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.bean;

import java.math.BigInteger;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;
import org.zz.gmhelper.BCECUtil;
import org.zz.gmhelper.SM2KeyPair;
import org.zz.gmhelper.SM2Util;

public abstract class SM2Verifiable {
    public String signature;

    public abstract String getPublicKey();

    public abstract void setPublicKey(String var1);

    public abstract String getContentStr();

    public void doSignature(String privateKey) {
        BigInteger pKey = new BigInteger(privateKey, 16);
        ECPoint p = SM2Util.G_POINT.multiply(pKey).normalize();
        this.doSignature(new SM2KeyPair(new ECPublicKeyParameters(p, SM2Util.DOMAIN_PARAMS), pKey));
    }

    public void doSignature(SM2KeyPair pair) {
        try {
            this.setPublicKey(pair.getPublicKeyStr());
            this.signature = ByteUtils.toHexString((byte[])SM2Util.sign((ECPrivateKeyParameters)pair.getPrivateKeyParameter(), (byte[])this.getContentStr().getBytes()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean verifySignature() {
        try {
            String verifiedStr = this.getContentStr();
            ECPublicKeyParameters pubKey = BCECUtil.createECPublicKeyFromStrParameters((String)this.getPublicKey(), (ECCurve)SM2Util.CURVE, (ECDomainParameters)SM2Util.DOMAIN_PARAMS);
            return SM2Util.verify((ECPublicKeyParameters)pubKey, (byte[])verifiedStr.getBytes(), (byte[])ByteUtils.fromHexString((String)this.signature));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }
}

