/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.db;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import org.bdware.sc.commParser.BlockBody;
import org.bdware.sc.util.HashUtil;

public class SqliteDBUtil {
    private Connection conn;

    public static SqliteDBUtil connect(String url) {
        try {
            String name = "org.sqlite.JDBC";
            SqliteDBUtil util = new SqliteDBUtil();
            String path = "jdbc:sqlite:";
            File file = new File(url);
            path = path + file.getAbsolutePath();
            System.out.println("[SqliteDBUtil] connect:" + path);
            Class.forName(name);
            util.conn = DriverManager.getConnection(path);
            return util;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public BlockBody getBlockBody(String headerHash, String bodyHash) {
        try {
            Statement stmt = this.conn.createStatement();
            String sql = "select * from BlockBody where ID = ?";
            PreparedStatement pre = this.conn.prepareStatement(sql);
            pre.setBytes(1, HashUtil.str16ToBytes(bodyHash));
            ResultSet result = pre.executeQuery();
            result.next();
            System.out.println(result.getBytes("ID"));
            return BlockBody.fromBytes(result.getBytes("Data"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] selectAll() {
        try {
            Statement stmt = this.conn.createStatement();
            String sql = "select * from BlockBody limit 0,1";
            PreparedStatement pre = this.conn.prepareStatement(sql);
            ResultSet result = pre.executeQuery();
            result.next();
            return result.getBytes(1);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

