/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.sc.ContractResult;
import org.bdware.sc.util.JsonUtil;

public class ComponedContractResult {
    public static final String EXPIRED_REQ = "requestID expired";
    private static final Logger LOGGER = LogManager.getLogger(ComponedContractResult.class);
    private final int THRESHOLD;
    Map<String, ContractResult> resultMap = new HashMap<String, ContractResult>();
    Set<String> problemNodes = new HashSet<String>();

    public ComponedContractResult(int c) {
        this.THRESHOLD = (int)Math.ceil((double)c / 2.0);
    }

    public synchronized void add(JsonObject obj) {
        ContractResult cr2;
        if (obj.has("status") && obj.get("status").getAsString().equals("Error") && obj.has("result") && obj.get("result").getAsString().equals("not fine")) {
            LOGGER.info("\u52a0\u5165\u4e00\u4e2a\u8282\u70b9\u7684\u6267\u884c\u7ed3\u679c\u662fnot infe!\u8be5\u8282\u70b9\u4e0d\u662f\u6b63\u5e38\u8fd0\u884c\u72b6\u6001!");
            String nodeID = obj.get("nodeID").getAsString();
            this.problemNodes.add(nodeID);
            LOGGER.info("\u95ee\u9898\u8282\u70b9\u4e2d\u52a0\u5165 " + nodeID.substring(0, 5));
            return;
        }
        if (obj.has("status") && obj.get("status").getAsString().equals("Error")) {
            LOGGER.info("\u52a0\u5165\u4e00\u4e2a\u8282\u70b9\u7684\u6267\u884c\u7ed3\u679c\u662fError!\u8be5\u8282\u70b9\u4e0b\u7ebf!");
            return;
        }
        try {
            cr2 = JsonUtil.fromJson(obj.get("data").getAsString(), ContractResult.class);
            if (cr2.status == ContractResult.Status.Error && cr2.result.getAsString().equals(EXPIRED_REQ)) {
                return;
            }
        }
        catch (Exception e) {
            Object str = null;
            cr2 = new ContractResult(ContractResult.Status.Error, (JsonElement)new JsonPrimitive("parse str failed:" + obj.toString()));
            e.printStackTrace();
        }
        this.resultMap.put(obj.get("nodeID").getAsString(), cr2);
    }

    public ContractResult figureFinalResult() {
        ContractResult finalResult = null;
        ConcurrentHashMap<JsonElement, Integer> map = new ConcurrentHashMap<JsonElement, Integer>();
        ConcurrentHashMap<JsonElement, ContractResult> tempMap = new ConcurrentHashMap<JsonElement, ContractResult>();
        for (String nodeID : this.resultMap.keySet()) {
            JsonElement str;
            ContractResult tempResult = this.resultMap.get(nodeID);
            if (tempResult.result == null) {
                tempResult.result = JsonNull.INSTANCE;
            }
            if (!map.containsKey(str = tempResult.result)) {
                map.put(str, 1);
                tempMap.put(str, tempResult);
                continue;
            }
            int temp = (Integer)map.get(str);
            map.put(str, temp + 1);
        }
        for (JsonElement str : map.keySet()) {
            if ((Integer)map.get(str) < this.THRESHOLD) continue;
            finalResult = (ContractResult)tempMap.get(str);
            break;
        }
        if (finalResult != null) {
            finalResult.size = (Integer)map.get(finalResult.result);
            for (String nodeID : this.resultMap.keySet()) {
                ContractResult temp = this.resultMap.get(nodeID);
                if (temp.result.equals(finalResult.result) || temp.status != ContractResult.Status.Error) continue;
                this.problemNodes.add(nodeID);
            }
        } else {
            finalResult = new ContractResult(ContractResult.Status.Error, (JsonElement)new JsonPrimitive("invalid result"));
            finalResult.analysis = JsonUtil.toPrettyJson(this.resultMap);
        }
        return finalResult;
    }

    public ContractResult mergeFinalResult() {
        ConcurrentHashMap map = new ConcurrentHashMap();
        JsonObject allJo = new JsonObject();
        ContractResult contractResult = new ContractResult(ContractResult.Status.Success, (JsonElement)allJo);
        for (String nodeID : this.resultMap.keySet()) {
            ContractResult tempResult = this.resultMap.get(nodeID);
            if (tempResult == null) continue;
            allJo.add(nodeID, tempResult.result);
        }
        return contractResult;
    }

    public Set<String> getProblemNodes() {
        return this.problemNodes;
    }
}

