/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.analysis.dynamic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.analysis.BasicBlock;
import org.bdware.analysis.BreadthFirstSearch;
import org.bdware.analysis.OpInfo;
import org.bdware.analysis.dynamic.TracedFile;
import org.bdware.analysis.taint.TaintBB;
import org.bdware.analysis.taint.TaintCFG;
import org.bdware.analysis.taint.TaintResult;
import org.bdware.analysis.taint.TaintValue;
import org.objectweb.asm.Label;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;

public class FieldSensitiveDynamicTaintAnalysis
extends BreadthFirstSearch<TaintResult, TaintBB> {
    private static final Logger LOGGER = LogManager.getLogger(FieldSensitiveDynamicTaintAnalysis.class);
    public static boolean isDebug = false;
    TaintCFG cfg;
    TracedFile tf;
    int count = 0;

    public FieldSensitiveDynamicTaintAnalysis(TaintCFG cfg, TracedFile tf) {
        this.cfg = cfg;
        this.tf = tf;
        ArrayList<TaintBB> toAnalysis = new ArrayList<TaintBB>();
        MethodNode mn = cfg.getMethodNode();
        LOGGER.info("mn: " + mn.name);
        String methodDesc = mn.desc;
        LOGGER.info("method desc: " + methodDesc);
        methodDesc = methodDesc.replaceAll("\\).*$", ")");
        LOGGER.info("method desc: " + methodDesc);
        int pos = 2;
        if (methodDesc.split(";").length == 3) {
            pos = 1;
        }
        LOGGER.info("p+++ " + pos);
        TaintBB b = (TaintBB)cfg.getBasicBlockAt(0);
        b.preResult = new TaintResult();
        LOGGER.info((Object)TaintResult.nLocals);
        if (TaintResult.nLocals > 2) {
            for (int i = 0; i < TaintResult.nLocals; ++i) {
                b.preResult.frame.setLocal(i, new TaintValue(1, i == pos ? 1L : 0L));
            }
        }
        b.preResult.ret = new TaintValue(1);
        toAnalysis.add(b);
        b.setInList(true);
        this.setToAnalysis(toAnalysis);
        if (isDebug) {
            MethodNode methodNode = cfg.getMethodNode();
            LOGGER.info("Method: " + methodNode.name + " " + methodNode.desc);
            LOGGER.info("Local: " + methodNode.maxLocals + " " + methodNode.maxStack);
        }
    }

    @Override
    public TaintResult execute(TaintBB t) {
        return t.forwardAnalysis();
    }

    @Override
    public Collection<TaintBB> getSuc(TaintBB t) {
        AbstractInsnNode insn;
        HashSet<BasicBlock> subBlock = new HashSet<BasicBlock>();
        if (t.list.size() > 0 && (insn = t.lastInsn()) != null) {
            OpInfo info = null;
            if (insn.getOpcode() >= 0) {
                info = OpInfo.ops[insn.getOpcode()];
            }
            if (info == null) {
                subBlock.addAll(this.cfg.getSucBlocks(t));
            } else if (info.canThrow()) {
                subBlock.add(this.cfg.getBasicBlockAt(t.blockID + 1));
            } else if (OpInfo.ops[insn.getOpcode()].canBranch()) {
                int block = this.handleBranchCase(subBlock, insn, t);
                subBlock.add(this.cfg.getBasicBlockAt(block));
            } else if (OpInfo.ops[insn.getOpcode()].canSwitch()) {
                subBlock.add(this.cfg.getBasicBlockAt(t.blockID + 1));
            } else {
                subBlock.addAll(this.cfg.getSucBlocks(t));
            }
        }
        HashSet<TaintBB> ret = new HashSet<TaintBB>();
        for (BasicBlock bb : subBlock) {
            TaintBB ntbb = (TaintBB)bb;
            ntbb.preResult.mergeResult(t.sucResult);
            ret.add(ntbb);
        }
        return ret;
    }

    private int handleBranchCase(Set<BasicBlock> subBlock, AbstractInsnNode insn, TaintBB t) {
        int blockid = 0;
        switch (insn.getOpcode()) {
            case 154: {
                ++this.count;
                if (this.tf.trans.get((int)0).tmToVal.get(0).get(0) != 0) {
                    if (insn instanceof JumpInsnNode) {
                        LabelNode jump = ((JumpInsnNode)insn).label;
                        blockid = this.cfg.getBasicBlockByLabel((Label)jump.getLabel()).blockID;
                    }
                } else {
                    blockid = t.blockID + 1;
                }
                return blockid;
            }
            case 153: {
                if (this.tf.trans.get((int)0).tmToVal.get(0).get(0) == 0) {
                    if (insn instanceof JumpInsnNode) {
                        LabelNode jump = ((JumpInsnNode)insn).label;
                        blockid = this.cfg.getBasicBlockByLabel((Label)jump.getLabel()).blockID;
                    }
                } else {
                    blockid = t.blockID + 1;
                }
                return blockid;
            }
            case 156: {
                if (this.tf.trans.get((int)0).tmToVal.get(0).get(0) >= 0) {
                    if (insn instanceof JumpInsnNode) {
                        LabelNode jump = ((JumpInsnNode)insn).label;
                        blockid = this.cfg.getBasicBlockByLabel((Label)jump.getLabel()).blockID;
                    }
                } else {
                    blockid = t.blockID + 1;
                }
                return blockid;
            }
            case 158: {
                if (this.tf.trans.get((int)0).tmToVal.get(0).get(0) <= 0) {
                    if (insn instanceof JumpInsnNode) {
                        LabelNode jump = ((JumpInsnNode)insn).label;
                        blockid = this.cfg.getBasicBlockByLabel((Label)jump.getLabel()).blockID;
                    }
                } else {
                    blockid = t.blockID + 1;
                }
                return blockid;
            }
            case 155: {
                if (this.tf.trans.get((int)0).tmToVal.get(0).get(0) < 0) {
                    if (insn instanceof JumpInsnNode) {
                        LabelNode jump = ((JumpInsnNode)insn).label;
                        blockid = this.cfg.getBasicBlockByLabel((Label)jump.getLabel()).blockID;
                    }
                } else {
                    blockid = t.blockID + 1;
                }
                return blockid;
            }
            case 157: {
                if (this.tf.trans.get((int)0).tmToVal.get(0).get(0) < 0) {
                    if (insn instanceof JumpInsnNode) {
                        LabelNode jump = ((JumpInsnNode)insn).label;
                        blockid = this.cfg.getBasicBlockByLabel((Label)jump.getLabel()).blockID;
                    }
                } else {
                    blockid = t.blockID + 1;
                }
                return blockid;
            }
            default: {
                break;
            }
            case 167: {
                if (!(insn instanceof JumpInsnNode)) break;
                LabelNode jump = ((JumpInsnNode)insn).label;
                blockid = this.cfg.getBasicBlockByLabel((Label)jump.getLabel()).blockID;
            }
        }
        return blockid;
    }
}

