/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.analysis.taint;

import org.bdware.analysis.taint.TaintResult;
import org.objectweb.asm.tree.analysis.Value;

public class TaintValue
implements Value {
    public int size;
    public long isTainted;

    public TaintValue(int size) {
        this.size = size;
        this.isTainted = 0L;
    }

    public TaintValue(int size, long isTainted) {
        this.size = size;
        this.isTainted = isTainted;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    public String toString() {
        String s = Long.toBinaryString(this.isTainted);
        char[] c = s.toCharArray();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < c.length; ++i) {
            if (c[i] == '1') {
                buf.append("1/");
                continue;
            }
            buf.append("0/");
        }
        buf.append("--");
        return buf.toString();
    }

    public TaintValue clone() {
        TaintValue ret = new TaintValue(this.size);
        ret.isTainted = this.isTainted;
        return ret;
    }

    public String toReadableTaint() {
        return TaintResult.interpreter.taintBits.parse(this.isTainted);
    }

    public void merge(TaintValue target) {
        if (target != null) {
            this.isTainted |= target.isTainted;
        }
    }
}

