/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import javax.script.ScriptException;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileUtil {
    private static final Logger LOGGER = LogManager.getLogger(FileUtil.class);

    public static String getDir(String fullFileName) {
        return fullFileName.substring(0, fullFileName.lastIndexOf(File.separatorChar) + 1);
    }

    public static void copyFile(String src, String dst) {
        try {
            File fromFile = new File(src);
            File toFile = new File(dst);
            FileUtil.copyFile(fromFile, toFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void copyFile(InputStream in, OutputStream out) {
        try {
            int len;
            byte[] buffer = new byte[10240];
            while ((len = in.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void copyFile(File src, File dst) {
        try {
            if (!src.exists()) {
                throw new ScriptException("src file name");
            }
            if (src.isDirectory()) {
                FileUtils.copyDirectory((File)src, (File)dst);
            } else {
                FileUtils.copyFile((File)src, (File)dst);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getFileName(String string) {
        return string.substring(string.lastIndexOf("/") + 1);
    }

    public static String getFileContent(String path) {
        try {
            File file = new File(path);
            long fileLen = file.length();
            byte[] fileContent = new byte[(int)fileLen];
            FileInputStream in = new FileInputStream(file);
            LOGGER.debug("read content from " + path + ": " + in.read(fileContent));
            in.close();
            return new String(fileContent, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            LOGGER.error("getContent Meets Exception: " + e.getMessage());
            return null;
        }
    }

    public static PrintStream openFileAsPrinter(String path, boolean isAppend) {
        try {
            File f = new File(path);
            if (!f.getParentFile().exists()) {
                LOGGER.trace("create directory " + path + ": " + f.getParentFile().mkdirs());
            }
            return new PrintStream(new FileOutputStream(f, isAppend));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getString(InputStream is) {
        try {
            int l;
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            byte[] arr = new byte[1024];
            while ((l = is.read(arr)) > 0) {
                bo.write(arr, 0, l);
            }
            return bo.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

