/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.analysis.example;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.analysis.BasicBlock;
import org.bdware.analysis.BreadthFirstSearch;
import org.bdware.analysis.taint.TaintBB;
import org.bdware.analysis.taint.TaintCFG;
import org.bdware.analysis.taint.TaintResult;
import org.bdware.analysis.taint.TaintValue;
import org.objectweb.asm.tree.MethodNode;

public class FieldSensitiveTaintAnalysis
extends BreadthFirstSearch<TaintResult, TaintBB> {
    private static final Logger LOGGER = LogManager.getLogger(FieldSensitiveTaintAnalysis.class);
    public static boolean isDebug = false;
    TaintCFG cfg;

    public FieldSensitiveTaintAnalysis(TaintCFG cfg) {
        this.cfg = cfg;
        ArrayList<TaintBB> toAnalysis = new ArrayList<TaintBB>();
        TaintBB b = (TaintBB)cfg.getBasicBlockAt(0);
        b.preResult = new TaintResult();
        int arg = cfg.argsLocal();
        cfg.executeLocal();
        TaintResult.interpreter.setTaintBits(cfg.taintBits);
        b.preResult.frame.setLocal(arg, new TaintValue(1, cfg.taintBits.allocate("arg" + arg)));
        b.preResult.ret = new TaintValue(1);
        TaintResult.printer.setLabelOrder(cfg.getLabelOrder());
        toAnalysis.add(b);
        b.setInList(true);
        this.setToAnalysis(toAnalysis);
        if (isDebug) {
            MethodNode methodNode = cfg.getMethodNode();
            LOGGER.info("Method: " + methodNode.name + " " + methodNode.desc);
            LOGGER.info("Local: " + methodNode.maxLocals + " " + methodNode.maxStack);
        }
    }

    @Override
    public TaintResult execute(TaintBB t) {
        return t.forwardAnalysis();
    }

    @Override
    public Collection<TaintBB> getSuc(TaintBB t) {
        Set<BasicBlock> subBlock = this.cfg.getSucBlocks(t);
        HashSet<TaintBB> ret = new HashSet<TaintBB>();
        for (BasicBlock bb : subBlock) {
            TaintBB ntbb = (TaintBB)bb;
            ntbb.preResult.mergeResult(t.sucResult);
            ret.add(ntbb);
        }
        return ret;
    }
}

