/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.analysis.gas;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bdware.analysis.BasicBlock;
import org.bdware.analysis.CFGraph;
import org.bdware.analysis.OpInfo;
import org.bdware.analysis.gas.DFS;
import org.bdware.analysis.gas.FeeSchedule;
import org.objectweb.asm.Label;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;

public class PPCount
extends DFS {
    CFGraph cfg;
    String functionGlobel;
    private String bdName;
    private int globalInvoke = 0;
    static List<String> functionList = new ArrayList<String>();
    private int globalBlockID;
    public static Map<String, HashMap<String, Integer>> varInsnCount = new HashMap<String, HashMap<String, Integer>>();
    public static HashMap<String, Set<Map<Integer, HashMap<String, Integer>>>> branchCount = new HashMap();
    public static Map<Integer, HashMap<String, Integer>> callFunction = new HashMap<Integer, HashMap<String, Integer>>();
    public static Map<Integer, HashMap<String, Integer>> BlockInsn = new HashMap<Integer, HashMap<String, Integer>>();
    public static Map<Integer, Set<Map<Integer, HashMap<String, Integer>>>> ppMap = new HashMap<Integer, Set<Map<Integer, HashMap<String, Integer>>>>();
    public HashSet<Integer> countBlock = new HashSet();
    boolean[] isBranchBlock;
    int jumpBlockid = -1;
    int conBlockid = -1;
    private boolean isBranch = false;
    private List<Integer> globalBranch = new ArrayList<Integer>();
    int lastBlockId = 0;
    int globalBlock = 0;
    int perBlockId = 0;
    boolean branchEnd;
    public static HashMap<String, Long> functionSumGas = new HashMap();

    public PPCount(CFGraph cfg, int flag) {
        this.cfg = cfg;
        this.functionGlobel = cfg.getMethodNode().name;
        varInsnCount.put(this.functionGlobel, new HashMap());
        this.globalInvoke = flag;
        ppMap.put(this.globalInvoke, new HashSet());
        callFunction.put(flag, new HashMap());
        ArrayList<BasicBlock> toAnalysis = new ArrayList<BasicBlock>();
        BasicBlock b = cfg.getBasicBlockAt(0);
        toAnalysis.add(b);
        b.setInList(true);
        functionList.add(cfg.getMethodNode().name);
        this.isBranchBlock = new boolean[cfg.getBasicBlockSize()];
    }

    @Override
    public Set<BasicBlock> getSuc(BasicBlock t) {
        Set<BasicBlock> subBlock = this.cfg.getSucBlocks(t);
        this.typeCount(t);
        return subBlock;
    }

    private void typeCount(BasicBlock t) {
        int count = 0;
        this.countBlock.add(t.blockID);
        this.globalBlockID = t.blockID;
        BlockInsn.put(t.blockID, new HashMap());
        List<AbstractInsnNode> insnList = t.getInsn();
        OpInfo info = null;
        if (t.list.size() > 0) {
            for (AbstractInsnNode ab : insnList) {
                if (ab == null || ab.getOpcode() < 0) continue;
                ++count;
            }
        }
        t.insnCount = count;
        if (t.list.size() > 0) {
            for (int i = 0; i < insnList.size(); ++i) {
                AbstractInsnNode insn = insnList.get(i);
                if (insn == null) continue;
                if (insn.getOpcode() >= 0) {
                    info = OpInfo.ops[insn.getOpcode()];
                }
                if (info == null) continue;
                if (info.canThrow()) {
                    this.callCount(insn, t);
                    continue;
                }
                if (info.canBranch()) {
                    this.normalCount(insn, t);
                    this.jumpCount(insn, t);
                    continue;
                }
                if (!info.canContinue() && !info.canSwitch() && !info.canReturn()) continue;
                this.normalCount(insn, t);
            }
        }
        this.addBlock(t);
        this.removeBranch();
    }

    private void jumpCount(AbstractInsnNode insn, BasicBlock t) {
        switch (insn.getOpcode()) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 158: {
                this.isBranch = true;
                this.globalBranch.add(this.globalInvoke);
                HashMap<Integer, HashMap<String, Integer>> map = new HashMap<Integer, HashMap<String, Integer>>();
                HashMap<Integer, HashMap<String, Integer>> map2 = new HashMap<Integer, HashMap<String, Integer>>();
                HashSet<HashMap<Integer, HashMap<String, Integer>>> ret = new HashSet<HashMap<Integer, HashMap<String, Integer>>>();
                HashSet<HashMap<Integer, HashMap<String, Integer>>> ret2 = new HashSet<HashMap<Integer, HashMap<String, Integer>>>();
                map.put(t.blockID, BlockInsn.get(t.blockID));
                map2.put(t.blockID - 1, BlockInsn.get(t.blockID - 1));
                ret.add(map);
                ret.add(map2);
                ret2.add(map);
                ret2.add(map2);
                if (insn instanceof JumpInsnNode) {
                    LabelNode jump = ((JumpInsnNode)insn).label;
                    this.jumpBlockid = this.cfg.getBasicBlockByLabel((Label)jump.getLabel()).blockID;
                    branchCount.put(this.globalInvoke + "false" + this.jumpBlockid, ret);
                }
                this.conBlockid = t.blockID + 1;
                branchCount.put(this.globalInvoke + "true" + this.conBlockid, ret2);
                break;
            }
            case 157: {
                if (insn instanceof JumpInsnNode) {
                    LabelNode jump = ((JumpInsnNode)insn).label;
                    this.jumpBlockid = this.cfg.getBasicBlockByLabel((Label)jump.getLabel()).blockID;
                    branchCount.put(this.globalInvoke + "false" + this.jumpBlockid, new HashSet());
                }
                this.conBlockid = t.blockID + 1;
                branchCount.put(this.globalInvoke + "true" + this.conBlockid, new HashSet());
                break;
            }
            case 159: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 170: 
            case 171: 
            case 199: {
                this.lastBlockId = t.blockID + 1;
            }
        }
    }

    private void normalCount(AbstractInsnNode insn, BasicBlock t) {
        int gb;
        if (t.blockID != this.lastBlockId) {
            this.lastBlockId = t.blockID;
            this.globalBlock = 0;
        }
        OpInfo info = OpInfo.ops[insn.getOpcode()];
        this.bdName = FeeSchedule.BDInsn.name();
        if (BlockInsn.get(this.globalBlockID).containsKey(this.bdName)) {
            BlockInsn.get(this.globalBlockID).put(this.bdName, BlockInsn.get(this.globalBlockID).get(this.bdName) + 1);
        } else {
            BlockInsn.get(this.globalBlockID).put(this.bdName, 1);
        }
        ++this.globalBlock;
        if (this.globalBranch.size() != 0 && (gb = this.globalBranch.get(this.globalBranch.size() - 1).intValue()) == this.globalInvoke && this.globalBlock == t.insnCount && !(insn instanceof JumpInsnNode)) {
            this.chosenBranch(t);
        }
    }

    private void chosenBranch(BasicBlock t) {
        if (this.globalBranch.size() != 0) {
            int branch = this.globalBranch.get(this.globalBranch.size() - 1);
            Set<Object> ret = new HashSet();
            if (this.isBranch && t.blockID < this.jumpBlockid) {
                this.isBranchBlock[t.blockID] = true;
                if (branchCount.get(branch + "true" + this.conBlockid) != null && !branchCount.get(branch + "true" + this.conBlockid).isEmpty()) {
                    ret = branchCount.get(branch + "true" + this.conBlockid);
                    HashMap<Integer, HashMap<String, Integer>> map = new HashMap<Integer, HashMap<String, Integer>>();
                    map.put(t.blockID, BlockInsn.get(t.blockID));
                    ret.add(map);
                    branchCount.put(branch + "true" + this.conBlockid, ret);
                } else if (branchCount.get(branch + "true" + this.conBlockid) != null) {
                    ret = branchCount.get(branch + "true" + this.conBlockid);
                    HashMap<Integer, HashMap<String, Integer>> map = new HashMap<Integer, HashMap<String, Integer>>();
                    map.put(t.blockID, BlockInsn.get(t.blockID));
                    branchCount.get(branch + "true" + this.conBlockid).add(map);
                }
            } else if (this.isBranch && t.blockID >= this.jumpBlockid) {
                this.isBranchBlock[t.blockID] = true;
                if (branchCount.get(branch + "false" + this.jumpBlockid) != null && !branchCount.get(branch + "false" + this.jumpBlockid).isEmpty()) {
                    Set<Map<Integer, HashMap<String, Integer>>> list = branchCount.get(branch + "false" + this.jumpBlockid);
                    HashMap<Integer, HashMap<String, Integer>> map = new HashMap<Integer, HashMap<String, Integer>>();
                    map.put(t.blockID, BlockInsn.get(t.blockID));
                    list.add(map);
                    branchCount.put(branch + "false" + this.jumpBlockid, list);
                } else if (branchCount.get(branch + "false" + this.jumpBlockid) != null) {
                    HashMap<Integer, HashMap<String, Integer>> map = new HashMap<Integer, HashMap<String, Integer>>();
                    if (ret.isEmpty()) {
                        map.put(t.blockID, BlockInsn.get(t.blockID));
                        branchCount.get(branch + "false" + this.jumpBlockid).add(map);
                    }
                }
            }
        }
    }

    public void removeBranch() {
        if (!this.globalBranch.isEmpty()) {
            for (int i = 0; i < this.globalBranch.size(); ++i) {
                if (!ppMap.containsKey(this.globalBranch.get(i))) continue;
                ppMap.remove(this.globalBranch.get(i));
            }
        }
    }

    private void callCount(AbstractInsnNode insn, BasicBlock t) {
        boolean isNewCall = false;
        this.lastBlockId = t.blockID;
        if (insn instanceof InvokeDynamicInsnNode) {
            Object invoke = ((InvokeDynamicInsnNode)insn).bsmArgs[0];
            String functionName = ((InvokeDynamicInsnNode)insn).name;
            isNewCall = true;
            if ((Integer)invoke > 5) {
                this.dynCount(functionName);
                this.globalInvoke = (Integer)invoke;
                ppMap.put((int)((Integer)invoke), new HashSet());
                this.perBlockId = t.blockID;
            } else {
                this.dynCount(functionName);
            }
        } else {
            this.normalCount(insn, t);
        }
        if (!isNewCall || t.blockID == this.jumpBlockid || t.blockID == this.conBlockid) {
            this.branchEnd = true;
            this.chosenBranch(t);
        }
    }

    private void addBlock(BasicBlock t) {
        if (t.list.size() > 0) {
            HashSet ret = new HashSet();
            HashMap<Integer, HashMap<String, Integer>> map = new HashMap<Integer, HashMap<String, Integer>>();
            map.put(t.blockID, BlockInsn.get(t.blockID));
            if (!this.isBranchBlock[t.blockID]) {
                if (!ppMap.containsKey(this.globalInvoke)) {
                    ppMap.put(this.globalInvoke, new HashSet());
                }
                ppMap.get(this.globalInvoke).add(map);
            }
        }
    }

    private void dynCount(String functionName) {
        String function = functionName.split(":")[1];
        if (function.contains("getProp")) {
            this.bdName = FeeSchedule.BDgetMethod.name();
            if (BlockInsn.get(this.globalBlockID).containsKey(this.bdName)) {
                BlockInsn.get(this.globalBlockID).put(this.bdName, BlockInsn.get(this.globalBlockID).get(this.bdName) + 1);
            } else {
                BlockInsn.get(this.globalBlockID).put(this.bdName, 1);
            }
        } else if (function.contains("setProp")) {
            this.bdName = FeeSchedule.BDsetMethod.name();
            if (BlockInsn.get(this.globalBlockID).containsKey(this.bdName)) {
                BlockInsn.get(this.globalBlockID).put(this.bdName, BlockInsn.get(this.globalBlockID).get(this.bdName) + 1);
            } else {
                BlockInsn.get(this.globalBlockID).put(this.bdName, 1);
            }
        } else if (function.contains("new")) {
            this.bdName = FeeSchedule.BDnew.name();
            if (BlockInsn.get(this.globalBlockID).containsKey(this.bdName)) {
                BlockInsn.get(this.globalBlockID).put(this.bdName, BlockInsn.get(this.globalBlockID).get(this.bdName) + 1);
            } else {
                BlockInsn.get(this.globalBlockID).put(this.bdName, 1);
            }
        } else if (function.contains("call") && functionName.split(":")[2].contains("Util")) {
            this.bdName = FeeSchedule.BDcallUtil.name();
            if (BlockInsn.get(this.globalBlockID).containsKey(this.bdName)) {
                BlockInsn.get(this.globalBlockID).put(this.bdName, BlockInsn.get(this.globalBlockID).get(this.bdName) + 1);
            } else {
                BlockInsn.get(this.globalBlockID).put(this.bdName, 1);
            }
        } else if (function.contains("call") && this.isInnerfunction(functionName)) {
            String methName = functionName.split(":")[2];
            this.bdName = FeeSchedule.BDcallFuntion.name();
            if (BlockInsn.get(this.globalBlockID).containsKey(this.bdName)) {
                BlockInsn.get(this.globalBlockID).put(this.bdName + "," + methName, BlockInsn.get(this.globalBlockID).get(this.bdName + "," + methName) + 1);
                System.out.println("   function   " + functionName);
            } else {
                BlockInsn.get(this.globalBlockID).put(this.bdName + "," + methName, 1);
            }
        } else if (function.contains("call")) {
            this.bdName = FeeSchedule.BDcall.name();
            if (BlockInsn.get(this.globalBlockID).containsKey(this.bdName)) {
                BlockInsn.get(this.globalBlockID).put(this.bdName, BlockInsn.get(this.globalBlockID).get(this.bdName) + 1);
            } else {
                BlockInsn.get(this.globalBlockID).put(this.bdName, 1);
            }
        } else if (functionName.contains("traceif")) {
            this.bdName = FeeSchedule.BDjump.name();
            if (BlockInsn.get(this.globalBlockID).containsKey(this.bdName)) {
                BlockInsn.get(this.globalBlockID).put(this.bdName, BlockInsn.get(this.globalBlockID).get(this.bdName) + 1);
            } else {
                BlockInsn.get(this.globalBlockID).put(this.bdName, 1);
            }
        }
    }

    private boolean isInnerfunction(String functionName) {
        String string = functionName.split(":")[2];
        return functionList.contains(string);
    }

    public static void countFunction(String functionName, HashMap<String, Long> map) {
        long sumTrue = 0L;
        long sumFalse = 0L;
        long sum = 0L;
        for (Map.Entry<String, Long> entry : map.entrySet()) {
            if (entry.getKey().contains("true")) {
                sumTrue = entry.getValue();
                continue;
            }
            if (entry.getKey().contains("false")) {
                sumFalse = entry.getValue();
                continue;
            }
            sum += entry.getValue().longValue();
        }
        functionSumGas.put(functionName, sum);
        functionSumGas.put(functionName + "true", sumTrue);
        functionSumGas.put(functionName + "false", sumFalse);
    }
}

