/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.sc.encrypt.HardwareInfo;
import org.bdware.sc.gen.PYGenerator;
import org.bdware.sc.node.ContractManifest;
import org.bdware.sc.packer.AvatarHelper;
import org.bdware.sc.py.PYEntry;
import org.bdware.sc.py.bean.PYModule;
import org.bdware.sc.py.bean.PYPackage;
import org.bdware.sc.util.JsonUtil;

public class YJSPacker {
    private static final String MANIFEST_NAME = "manifest.json";
    private static final String JAR_NAME = "py.jar";
    private static final Logger LOGGER = LogManager.getLogger(YJSPacker.class);
    private static final String LOGO_NAME = "logo.png";

    public static byte[] pack(String dir) {
        try {
            File d = new File(dir);
            ByteArrayOutputStream fout = new ByteArrayOutputStream();
            ZipOutputStream zout = new ZipOutputStream(fout);
            YJSPacker.updateManifest(dir + "/" + MANIFEST_NAME);
            YJSPacker.generateLogoIfNotExist(dir);
            YJSPacker.walkDir(d.getAbsolutePath(), d, zout);
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            boolean hasContent = YJSPacker.packFromManifest(new ZipOutputStream(bo), dir + "/" + MANIFEST_NAME);
            if (hasContent) {
                zout.putNextEntry(new ZipEntry(JAR_NAME));
                zout.write(bo.toByteArray());
                zout.closeEntry();
            }
            zout.close();
            fout.close();
            return fout.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void pack(String dir, String target) {
        try {
            File d = new File(dir);
            File parent = new File(target).getParentFile();
            if (!parent.exists()) {
                LOGGER.trace("create directory " + parent.getAbsolutePath() + ": " + parent.mkdirs());
            }
            FileOutputStream fout = new FileOutputStream(target);
            ZipOutputStream zout = new ZipOutputStream(fout);
            YJSPacker.updateManifest(dir + "/" + MANIFEST_NAME);
            YJSPacker.generateLogoIfNotExist(dir);
            YJSPacker.walkDir(d.getAbsolutePath(), d, zout);
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            boolean hasContent = YJSPacker.packFromManifest(new ZipOutputStream(bo), dir + "/" + MANIFEST_NAME);
            if (hasContent) {
                zout.putNextEntry(new ZipEntry(JAR_NAME));
                zout.write(bo.toByteArray());
                zout.closeEntry();
            }
            zout.close();
            fout.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void generateLogoIfNotExist(String dir) {
        File logoDir = new File(dir, "assets");
        if (!logoDir.exists()) {
            LOGGER.trace("create directory " + logoDir.getAbsolutePath() + ": " + logoDir.mkdirs());
        }
        File logo = new File(logoDir, LOGO_NAME);
        String builderName = new File(dir).getParentFile().getName();
        String sourcePath = builderName + "/" + new File(dir).getName();
        if (!logo.exists()) {
            try {
                FileUtils.writeByteArrayToFile((File)logo, (byte[])AvatarHelper.create(sourcePath));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void updateManifest(String s) throws Exception {
        File manifest = new File(s);
        String content = FileUtils.readFileToString((File)manifest, (String)"UTF-8");
        LOGGER.debug(content);
        ContractManifest cm = JsonUtil.fromJson(content, ContractManifest.class);
        String builderName = manifest.getParentFile().getParentFile().getName();
        cm.sourcePath = builderName + "/" + manifest.getParentFile().getName();
        LOGGER.info("DOI:" + cm.doi);
        if (null == cm.doi || cm.doi.isEmpty()) {
            cm.doi = "Contract_" + cm.sourcePath.hashCode();
        }
        cm.buildTime = System.currentTimeMillis();
        cm.builder = builderName.length() > 100 && builderName.startsWith("04") ? builderName : "ContractEngine";
        FileUtils.writeStringToFile((File)manifest, (String)JsonUtil.toPrettyJson(cm), (String)"UTF-8");
    }

    private static void walkDir(String preFix, File d, ZipOutputStream zout) {
        try {
            if (d.isDirectory()) {
                for (File f : d.listFiles()) {
                    YJSPacker.walkDir(preFix, f, zout);
                }
            } else {
                int l;
                String entryName = d.getAbsolutePath().replace(preFix, "");
                if (HardwareInfo.type == HardwareInfo.OSType.win) {
                    entryName = entryName.replaceAll("\\\\", "/");
                }
                zout.putNextEntry(new ZipEntry(entryName));
                FileInputStream fin = new FileInputStream(d);
                byte[] buff = new byte[1024];
                while ((l = fin.read(buff)) > 0) {
                    zout.write(buff, 0, l);
                }
                zout.closeEntry();
                fin.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean packFromManifest(ZipOutputStream zout, String manifestPath) {
        boolean hasContent = false;
        try {
            LOGGER.debug("manifestPath = " + manifestPath);
            File file = new File(manifestPath);
            String content = FileUtils.readFileToString((File)file, (String)"UTF-8");
            LOGGER.debug(content);
            ContractManifest cm = JsonUtil.fromJson(content, ContractManifest.class);
            if (cm.getInsnLimit() != 0L) {
                LOGGER.debug((Object)cm.insnLimit);
            }
            if (cm.getPyDependences() != null) {
                for (PYPackage pyPkg : cm.getPyDependences()) {
                    ArrayList<PYModule> list = new ArrayList<PYModule>();
                    if (pyPkg.getModules() == null || pyPkg.getModules().isEmpty()) {
                        pyPkg = PYEntry.instance.packageInfo(pyPkg.getName());
                    } else {
                        for (PYModule pyModule : pyPkg.getModules()) {
                            PYModule info = PYEntry.instance.moduleInfo(pyPkg.getName() + "." + pyModule.getName());
                            info.setName(pyModule.getName());
                            LOGGER.debug(pyPkg.getName() + "." + pyModule.getName());
                            list.add(info);
                        }
                    }
                    if (!list.isEmpty()) {
                        pyPkg.setModules(list);
                    }
                    PYGenerator pmc = new PYGenerator();
                    hasContent = true;
                    pmc.genClassFiles(zout, pyPkg);
                }
            }
            zout.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hasContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getConfig(String input, String path, Class<T> clz) {
        ZipFile zin = null;
        try {
            zin = new ZipFile(new File(input));
            ZipEntry entry = zin.getEntry(path);
            T t = JsonUtil.fromJson((Reader)new InputStreamReader(zin.getInputStream(entry)), clz);
            return t;
        }
        catch (Exception e) {
            LOGGER.warn("read " + clz.getSimpleName() + " failed: " + e.getMessage());
        }
        finally {
            if (null != zin) {
                try {
                    zin.close();
                }
                catch (Exception e) {
                    LOGGER.error("closing zin failed: " + e.getMessage());
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContractManifest getMan2(String input, String path) {
        ZipFile zin = null;
        try {
            zin = new ZipFile(new File(input));
            ZipEntry entry = zin.getEntry(path);
            ContractManifest contractManifest = JsonUtil.fromJson((Reader)new InputStreamReader(zin.getInputStream(entry)), ContractManifest.class);
            return contractManifest;
        }
        catch (Exception e) {
            e.printStackTrace();
            ContractManifest contractManifest = null;
            return contractManifest;
        }
        finally {
            if (zin != null) {
                try {
                    zin.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static ContractManifest getManifest(String input) {
        try {
            ZipEntry entry;
            ZipInputStream zin = new ZipInputStream(new FileInputStream(input));
            byte[] buff = new byte[102400];
            ByteArrayInputStream manifestInput = null;
            while ((entry = zin.getNextEntry()) != null) {
                if (entry.getName().endsWith(MANIFEST_NAME)) {
                    int k;
                    while ((k = zin.read(buff)) > 0) {
                        manifestInput = new ByteArrayInputStream(buff, 0, k);
                    }
                }
                zin.closeEntry();
            }
            zin.close();
            if (manifestInput != null) {
                return JsonUtil.fromJson((Reader)new InputStreamReader(manifestInput), ContractManifest.class);
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void unpack(String input, String dir) {
        try {
            YJSPacker.unpackInternal(new FileInputStream(input), dir);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void unpack(byte[] input, String dir) {
        YJSPacker.unpackInternal(new ByteArrayInputStream(input), dir);
    }

    private static void unpackInternal(InputStream input, String dir) {
        try {
            ZipEntry entry;
            ZipInputStream zin = new ZipInputStream(input);
            byte[] buff = new byte[102400];
            while ((entry = zin.getNextEntry()) != null) {
                int k;
                File target = new File(dir, entry.getName());
                File parent = target.getParentFile();
                if (!parent.exists()) {
                    LOGGER.trace("create directory " + parent.getAbsolutePath() + ": " + parent.mkdirs());
                }
                if (!target.exists()) {
                    if (entry.isDirectory()) {
                        target.mkdirs();
                    } else {
                        target.createNewFile();
                    }
                }
                if (entry.isDirectory()) continue;
                FileOutputStream fout = new FileOutputStream(target);
                while ((k = zin.read(buff)) > 0) {
                    fout.write(buff, 0, k);
                }
                fout.close();
                zin.closeEntry();
            }
            zin.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

