/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.db;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import com.sleepycat.je.DatabaseException;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.sc.Jedion;
import org.bdware.sc.db.MultiIndexTimeDBUtilIntf;
import org.bdware.sc.index.TimeSerialIndex;
import org.bdware.sc.util.JsonUtil;

public class MultiIndexTimeDBUtil
implements MultiIndexTimeDBUtilIntf {
    private static final Logger LOGGER = LogManager.getLogger(MultiIndexTimeDBUtil.class);
    private final Map<String, TimeSerialIndex> secondaryIndex;
    public String dbPath;
    public String tableName;
    Random random = new Random();
    private Jedion db;
    private TimeSerialIndex primaryIndex;

    public MultiIndexTimeDBUtil(String path, String tableName) {
        this.secondaryIndex = new HashMap<String, TimeSerialIndex>();
        this.dbPath = path;
        this.tableName = tableName;
        this.setupDB();
    }

    private static void deleteJelck(File file) {
        if (file.exists()) {
            LOGGER.trace("delete file" + file.getAbsolutePath() + ": " + file.delete());
        }
    }

    private void setupDB() {
        this.db = new Jedion(this.tableName);
        File file = new File(this.dbPath + "/" + this.tableName);
        File timeIndex = new File(this.dbPath + "/" + this.tableName + "/DB.primary.timeindex");
        MultiIndexTimeDBUtil.deleteJelck(new File(file, "je.lck"));
        if (!file.exists()) {
            LOGGER.trace("create directory " + file.getAbsolutePath() + ": " + file.mkdirs());
        }
        this.db.configEnvironment(file);
        this.db.createDatabase();
        this.primaryIndex = new TimeSerialIndex(timeIndex.getAbsolutePath());
    }

    public synchronized void put(String label, String val) {
        TimeSerialIndex index = this.getIndex(label);
        long key = this.random.nextLong();
        index.index(key);
        if (index != this.primaryIndex) {
            this.primaryIndex.index(key);
        }
        this.db.writeToDatabase(String.valueOf(key), val, true);
    }

    public synchronized long queryOffset(String label, long begin) {
        TimeSerialIndex index = this.getIndex(label);
        return index.findNearest(begin);
    }

    public synchronized List<String> queryByDateAsString(String label, long begin, long end) {
        ArrayList<String> ret = new ArrayList<String>();
        TimeSerialIndex index = this.getIndex(label);
        long offset = index.findNearest(begin);
        long size = index.findNearest(end);
        int len = (int)(size - offset + 1L);
        List<Long> data = index.request(offset, len);
        for (Long l : data) {
            try {
                String t = this.db.readFromDatabase(l.toString());
                if (t.isEmpty()) continue;
                ret.add(t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    @Override
    public synchronized List<JsonObject> queryByDateAsJson(String label, long begin, long end) {
        ArrayList<JsonObject> ret = new ArrayList<JsonObject>();
        TimeSerialIndex index = this.getIndex(label);
        long offset = index.findNearest(begin);
        long size = index.findNearest(end);
        int len = (int)(size - offset + 1L);
        List<Long> data = index.request(offset, len);
        for (Long l : data) {
            String t = null;
            try {
                t = this.db.readFromDatabase(l.toString());
                if (t == null || t.isEmpty()) continue;
                JsonObject jo = JsonUtil.parseStringAsJsonObject(t);
                jo.addProperty("key", l.toString());
                ret.add(jo);
            }
            catch (Exception e) {
                LOGGER.error("parse db json error:" + t);
            }
        }
        return ret;
    }

    public long size() {
        return this.primaryIndex.size();
    }

    @Override
    public long size(String label) {
        try {
            TimeSerialIndex index = this.getIndex(label);
            if (index != null) {
                return index.size();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0L;
    }

    @Override
    public List<JsonObject> queryByOffset(String label, long offset, int count) {
        ArrayList<JsonObject> ret = new ArrayList<JsonObject>();
        TimeSerialIndex index = this.getIndex(label);
        List<Long> data = index.request(offset, count);
        for (Long l : data) {
            try {
                String t = this.db.readFromDatabase(l.toString());
                JsonObject jo = t != null && !t.isEmpty() ? JsonUtil.parseStringAsJsonObject(t) : new JsonObject();
                jo.addProperty("key", l.toString());
                ret.add(jo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public String get(String key) {
        try {
            return this.db.readFromDatabase(key);
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return null;
        }
    }

    private TimeSerialIndex getIndex(String label) {
        if (null == label) {
            return this.primaryIndex;
        }
        if (this.secondaryIndex.containsKey(label)) {
            return this.secondaryIndex.get(label);
        }
        TimeSerialIndex index = new TimeSerialIndex(this.dbPath + "/" + this.tableName + "/" + label + ".timeindex");
        this.secondaryIndex.putIfAbsent(label, index);
        return index;
    }

    public Map<String, Integer> querySort(String label, long date) {
        ArrayList ret = new ArrayList();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        TimeSerialIndex index = this.getIndex(label);
        long offset = index.findNearest(date);
        int len = (int)(index.size() - offset);
        List<Long> data = index.request(offset, len);
        for (Long l : data) {
            String t = null;
            try {
                t = this.db.readFromDatabase(l.toString());
                Map data2 = (Map)JsonUtil.fromJson(t, new TypeToken<Map<String, String>>(){}.getType());
                if (null == data2) continue;
                String action = (String)data2.get("action");
                if (map.containsKey(action)) {
                    int count = (Integer)map.get(action) + 1;
                    map.put(action, count);
                    continue;
                }
                map.put(action, 1);
            }
            catch (Exception e) {
                LOGGER.error("parse db json error:" + t);
            }
        }
        return map;
    }

    @Override
    public JsonArray countInInterval(String label, long start, long interval, long end) {
        TimeSerialIndex index = this.getIndex(label);
        long offset = index.findNearest(start);
        JsonArray array = new JsonArray();
        do {
            long offset2 = index.findNearest(start += interval);
            array.add((Number)(offset2 - offset));
            offset = offset2;
        } while (start < end);
        return array;
    }

    public void rebuildIndex(String labelField) {
        try {
            List<Jedion.KV> dataKVs = this.db.getEveryKeyValue();
            HashMap<Long, Jedion.KV> memoryIndex = new HashMap<Long, Jedion.KV>();
            ArrayList<Long> times = new ArrayList<Long>();
            for (Jedion.KV dataKV : dataKVs) {
                JsonObject jo = JsonUtil.fromJson(dataKV.value, JsonObject.class);
                Long time = jo.get("date").getAsLong();
                if (time < 0L) continue;
                times.add(time);
                memoryIndex.put(time, dataKV);
            }
            times.sort(Long::compareTo);
            for (Long time : times) {
                Jedion.KV dataKV = (Jedion.KV)memoryIndex.get(time);
                JsonObject jo = JsonUtil.fromJson(dataKV.value, JsonObject.class);
                TimeSerialIndex tsi = this.getIndex(jo.get(labelField).getAsString());
                tsi.manullyIndex(time, Long.parseLong(dataKV.key));
                this.primaryIndex.manullyIndex(time, Long.parseLong(dataKV.key));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

