/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.db;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.sc.db.CMTables;
import org.bdware.sc.index.TimeSerialIndex;
import org.bdware.sc.util.JsonUtil;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;

public class TimeRocksDBUtil {
    private static final Logger LOGGER = LogManager.getLogger(TimeRocksDBUtil.class);
    private final Map<String, RocksDB> dbLink;
    private final Map<String, TimeSerialIndex> index;
    public String dbPath;
    Random random = new Random();

    public TimeRocksDBUtil(String path) {
        this.dbLink = new HashMap<String, RocksDB>();
        this.index = new HashMap<String, TimeSerialIndex>();
        this.dbPath = path;
    }

    private RocksDB getDB(String dbName) {
        if (!this.dbLink.containsKey(dbName)) {
            this.setupDB(dbName);
        }
        return this.dbLink.get(dbName);
    }

    private void setupDB(String dbName) {
        Options options = new Options();
        options.setCreateIfMissing(true);
        File file = new File(this.dbPath + "/" + dbName);
        String path = file.getAbsolutePath();
        File lockFile = new File(path, "LOCK");
        lockFile.delete();
        RocksDB rocksDB = null;
        try {
            rocksDB = RocksDB.open((Options)options, (String)path);
        }
        catch (RocksDBException e) {
            e.printStackTrace();
        }
        File timeIndex = new File(this.dbPath + "/" + dbName + ".timeindex");
        this.dbLink.put(dbName, rocksDB);
        this.index.put(dbName, new TimeSerialIndex(timeIndex.getAbsolutePath()));
    }

    public void put(String dbName, String val) {
        RocksDB db = this.getDB(dbName);
        TimeSerialIndex index = this.getIndex(dbName);
        long key = this.random.nextLong();
        index.index(key);
        try {
            db.put(String.valueOf(key).getBytes(StandardCharsets.UTF_8), val.getBytes(StandardCharsets.UTF_8));
        }
        catch (RocksDBException e) {
            e.printStackTrace();
        }
    }

    public void reIndex(String dbName, String date, String val) {
        RocksDB db = this.getDB(dbName);
        TimeSerialIndex index = this.getIndex(dbName);
        long key = this.random.nextLong();
        index.manullyIndex(Long.parseLong(date), key);
        try {
            db.put(String.valueOf(key).getBytes(StandardCharsets.UTF_8), val.getBytes(StandardCharsets.UTF_8));
        }
        catch (RocksDBException e) {
            e.printStackTrace();
        }
    }

    public JsonArray countInIntreval(String dbName, long start, long interval, long end) {
        TimeSerialIndex index = this.getIndex(dbName);
        long offset = index.findNearest(start);
        JsonArray array = new JsonArray();
        do {
            long offset2 = index.findNearest(start += interval);
            array.add((Number)(offset2 - offset));
            offset = offset2;
        } while (start < end);
        return array;
    }

    public List<String> query(String dbName, long end) {
        ArrayList<String> ret = new ArrayList<String>();
        RocksDB db = this.getDB(dbName);
        TimeSerialIndex index = this.getIndex(dbName);
        long size = index.size();
        long offset = index.findNearest(end);
        int len = (int)(size - offset);
        List<Long> data = index.request(offset, len);
        for (Long l : data) {
            try {
                String t = new String(db.get(l.toString().getBytes(StandardCharsets.UTF_8)));
                if (t.isEmpty()) continue;
                ret.add(t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public String queryDetail(String dbName, String key) {
        try {
            RocksDB db = this.getDB(dbName);
            return new String(db.get(key.getBytes(StandardCharsets.UTF_8)));
        }
        catch (RocksDBException e) {
            e.printStackTrace();
            return null;
        }
    }

    public List<JsonObject> queryLogBefore(String dbName, long end, String contractName) {
        if (!dbName.equals(CMTables.LocalContractLogDB.toString())) {
            return null;
        }
        ArrayList<JsonObject> ret = new ArrayList<JsonObject>();
        RocksDB db = this.getDB(dbName);
        TimeSerialIndex index = this.getIndex(dbName);
        long size = index.size();
        long offset = index.findNearest(end);
        int len = (int)(size - offset);
        List<Long> data = index.request(offset, len);
        for (Long l : data) {
            try {
                String t = new String(db.get(l.toString().getBytes(StandardCharsets.UTF_8)));
                if (null == t || t.isEmpty()) continue;
                JsonObject jo = JsonUtil.parseStringAsJsonObject(t);
                jo.addProperty("key", l.toString());
                if (!jo.has("contractName") || !jo.get("contractName").getAsString().equals(contractName)) continue;
                ret.add(jo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public List<String> queryWithKey(String dbName, long end) {
        if (!dbName.equals(CMTables.LocalContractLogDB.toString())) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>();
        RocksDB db = this.getDB(dbName);
        TimeSerialIndex index = this.getIndex(dbName);
        long size = index.size();
        long offset = index.findNearest(end);
        int len = (int)(size - offset);
        List<Long> data = index.request(offset, len);
        for (Long l : data) {
            try {
                String t = new String(db.get(l.toString().getBytes(StandardCharsets.UTF_8)));
                if (t == null || t.isEmpty()) continue;
                t = t.substring(0, t.length() - 1);
                t = t + ",\"key\":\"" + l + "\"}";
                ret.add(t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public List<String> querySort(String dbName, long end) {
        if (!(dbName.equals("NC_CMLog") || dbName.equals("NC_NodeLogDB") || dbName.equals(CMTables.LocalNodeLogDB.toString()) || dbName.equals(CMTables.LocalContractLogDB.toString()))) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        RocksDB db = this.getDB(dbName);
        TimeSerialIndex index = this.getIndex(dbName);
        long size = index.size();
        long offset = index.findNearest(end);
        int len = (int)(size - offset);
        List<Long> data = index.request(offset, len);
        for (Long l : data) {
            try {
                String t = new String(db.get(l.toString().getBytes(StandardCharsets.UTF_8)));
                Map data2 = (Map)JsonUtil.fromJson(t, new TypeToken<Map<String, String>>(){}.getType());
                if (data2 == null) continue;
                String action = (String)data2.get("action");
                if (map.containsKey(action)) {
                    int count = (Integer)map.get(action) + 1;
                    map.put(action, count);
                    continue;
                }
                map.put(action, 1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (String key : map.keySet()) {
            ret.add("{\"action\":\"" + key + "\",\"times\":" + map.get(key) + "}");
        }
        return ret;
    }

    public List<String> queryDate(String dbName, long end) {
        if (!(dbName.equals("NC_CMLog") || dbName.equals("NC_NodeLogDB") || dbName.equals(CMTables.LocalNodeLogDB.toString()) || dbName.equals(CMTables.LocalContractLogDB.toString()))) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>();
        RocksDB db = this.getDB(dbName);
        TimeSerialIndex index = this.getIndex(dbName);
        long size = index.size();
        long offset = index.findNearest(end);
        int len = (int)(size - offset);
        List<Long> data = index.request(offset, len);
        for (Long l : data) {
            try {
                Map data2 = (Map)JsonUtil.fromJson(new String(db.get(l.toString().getBytes(StandardCharsets.UTF_8))), new TypeToken<Map<String, String>>(){}.getType());
                if (data2 == null) continue;
                String date = (String)data2.get("date");
                ret.add(date);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public List<String> queryByOffset(String dbName, int offset, int len) {
        ArrayList<String> ret = new ArrayList<String>();
        RocksDB db = this.getDB(dbName);
        TimeSerialIndex index = this.getIndex(dbName);
        List<Long> data = index.request(offset, len);
        for (Long l : data) {
            try {
                String t = new String(db.get(l.toString().getBytes(StandardCharsets.UTF_8)));
                ret.add(t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public String get(String dbName, String key) {
        RocksDB db = this.getDB(dbName);
        try {
            return new String(db.get(key.toString().getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private TimeSerialIndex getIndex(String dbName) {
        return this.index.get(dbName);
    }

    public long getCount(String dbName) {
        try {
            TimeSerialIndex index = this.getIndex(dbName);
            return index.size();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }
}

