/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.analysis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.analysis.BasicBlock;
import org.bdware.analysis.InsnPrinter;
import org.bdware.analysis.OpInfo;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;

public abstract class CFGraph {
    private static final Logger LOGGER = LogManager.getLogger(CFGraph.class);
    private final Map<BasicBlock, Set<BasicBlock>> preBlock;
    private final Map<Label, BasicBlock> labelToBB;
    private final Map<Label, Integer> labelOrder = new HashMap<Label, Integer>();
    protected List<BasicBlock> basicBlocks = new ArrayList<BasicBlock>();
    protected Map<BasicBlock, Set<BasicBlock>> sucBlock;
    MethodNode methodNode;

    public CFGraph(MethodNode mn) {
        this.preBlock = new HashMap<BasicBlock, Set<BasicBlock>>();
        this.sucBlock = new HashMap<BasicBlock, Set<BasicBlock>>();
        this.labelToBB = new HashMap<Label, BasicBlock>();
        this.methodNode = mn;
        this.buildBasicBlock(mn.instructions, mn.tryCatchBlocks);
    }

    private void addEdge(BasicBlock pre, BasicBlock suc) {
        Set<BasicBlock> pres = this.getPreBlocks(suc);
        pres.add(pre);
        Set<BasicBlock> sucs = this.getSucBlocks(pre);
        sucs.add(suc);
    }

    public Set<BasicBlock> getSucBlocks(BasicBlock pre) {
        if (null == this.sucBlock.get(pre)) {
            HashSet<BasicBlock> ret = new HashSet<BasicBlock>();
            this.sucBlock.put(pre, ret);
            return ret;
        }
        return this.sucBlock.get(pre);
    }

    public Set<BasicBlock> getPreBlocks(BasicBlock suc) {
        if (this.preBlock.get(suc) == null) {
            HashSet<BasicBlock> ret = new HashSet<BasicBlock>();
            this.preBlock.put(suc, ret);
            return ret;
        }
        return this.preBlock.get(suc);
    }

    public abstract BasicBlock getBasicBlock(int var1);

    private void buildBasicBlock(InsnList instructions, List<TryCatchBlockNode> tryCatchBlocks) {
        InsnPass1Visitor visitor = new InsnPass1Visitor(262144);
        visitor.currBlock = this.getBasicBlock(0);
        this.basicBlocks.add(visitor.currBlock);
        for (int i = 0; i < instructions.size(); ++i) {
            AbstractInsnNode insn = instructions.get(i);
            visitor.setCurrInsn(insn);
            insn.accept(visitor);
        }
        visitor.visitEnd();
        ArrayList<BasicBlock> merged = new ArrayList<BasicBlock>();
        for (BasicBlock bb : this.basicBlocks) {
            if (bb.list.size() <= 0) continue;
            merged.add(bb);
        }
        this.basicBlocks = merged;
        InsnPass2Visitor pass2 = new InsnPass2Visitor(262144);
        pass2.tryCatchBlocks = tryCatchBlocks;
        for (int i = 0; i < this.basicBlocks.size(); ++i) {
            pass2.blockid = i;
            BasicBlock bb = this.basicBlocks.get(i);
            bb.blockID = i;
            if (bb.size() > 0 && bb.list.get(0) instanceof LabelNode) {
                pass2.preLabel = ((LabelNode)bb.list.get(0)).getLabel();
            }
            for (AbstractInsnNode node : bb.list) {
                node.accept(pass2);
            }
        }
        int preLine = -1;
        for (BasicBlock block : this.basicBlocks) {
            if (block.lineNum != -1) {
                preLine = block.lineNum;
                continue;
            }
            block.lineNum = preLine;
        }
    }

    public void printSelf() {
        InsnPrinter printer = new InsnPrinter(262144, System.out);
        printer.setLabelOrder(this.getLabelOrder());
        LOGGER.info("isStatic: " + ((this.methodNode.access & 8) > 0) + "\tMethod:" + this.methodNode.name + "  " + this.methodNode.desc);
        LOGGER.info(this.methodNode.maxLocals + "  " + this.methodNode.maxStack);
        StringBuilder log = new StringBuilder();
        for (BasicBlock bb : this.basicBlocks) {
            log.append("B").append(bb.blockID);
            if (this.getSucBlocks(bb).size() > 0) {
                log.append(" -->");
            }
            for (BasicBlock suc : this.getSucBlocks(bb)) {
                log.append(" B").append(suc.blockID);
            }
            for (AbstractInsnNode an : bb.list) {
                an.accept(printer);
            }
            log.append("\n");
        }
        LOGGER.info(log.substring(0, log.length() - 1));
    }

    public Map<Label, Integer> getLabelOrder() {
        return this.labelOrder;
    }

    public BasicBlock getBasicBlockAt(int i) {
        return this.basicBlocks.get(i);
    }

    public int getBasicBlockSize() {
        return this.basicBlocks.size();
    }

    public MethodNode getMethodNode() {
        return this.methodNode;
    }

    public BasicBlock getBasicBlockByLabel(Label l) {
        return this.labelToBB.get(l);
    }

    private class InsnPass2Visitor
    extends MethodVisitor {
        int blockid;
        Label preLabel;
        List<TryCatchBlockNode> tryCatchBlocks;

        public InsnPass2Visitor(int api) {
            super(api);
        }

        public void addTryCatchNodes() {
            for (TryCatchBlockNode node : this.tryCatchBlocks) {
                Label l1 = node.start.getLabel();
                Label l2 = node.end.getLabel();
                Label l3 = node.handler.getLabel();
                if (!this.inLabel(l1, l2, this.preLabel)) continue;
                CFGraph.this.addEdge((BasicBlock)CFGraph.this.labelToBB.get(this.preLabel), (BasicBlock)CFGraph.this.labelToBB.get(l3));
            }
        }

        @Override
        public void visitLineNumber(int line, Label start) {
            BasicBlock currBlock = CFGraph.this.basicBlocks.get(this.blockid);
            currBlock.setLineNum(line);
        }

        @Override
        public void visitJumpInsn(int opcode, Label label) {
            BasicBlock currBlock = CFGraph.this.basicBlocks.get(this.blockid);
            BasicBlock targetBlock = (BasicBlock)CFGraph.this.labelToBB.get(label);
            CFGraph.this.addEdge(currBlock, targetBlock);
        }

        @Override
        public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
            BasicBlock currBlock = CFGraph.this.basicBlocks.get(this.blockid);
            BasicBlock targetBlock = (BasicBlock)CFGraph.this.labelToBB.get(dflt);
            CFGraph.this.addEdge(currBlock, targetBlock);
            for (Label label : labels) {
                targetBlock = (BasicBlock)CFGraph.this.labelToBB.get(label);
                CFGraph.this.addEdge(currBlock, targetBlock);
            }
        }

        @Override
        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
            BasicBlock currBlock = CFGraph.this.basicBlocks.get(this.blockid);
            BasicBlock targetBlock = (BasicBlock)CFGraph.this.labelToBB.get(dflt);
            CFGraph.this.addEdge(currBlock, targetBlock);
            for (Label label : labels) {
                targetBlock = (BasicBlock)CFGraph.this.labelToBB.get(label);
                CFGraph.this.addEdge(currBlock, targetBlock);
            }
        }

        @Override
        public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
            this.addTryCatchNodes();
        }

        private boolean inLabel(Label start, Label end, Label query) {
            int s = CFGraph.this.getLabelOrder().get(start);
            int e = CFGraph.this.getLabelOrder().get(end);
            int m = CFGraph.this.getLabelOrder().get(query);
            return m >= s && m < e;
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            this.addTryCatchNodes();
        }

        @Override
        public void visitInsn(int opcode) {
            if (OpInfo.ops[opcode].toString().contains("throw")) {
                this.addTryCatchNodes();
            }
        }
    }

    private class InsnPass1Visitor
    extends MethodVisitor {
        int count;
        AbstractInsnNode currInsn;
        BasicBlock currBlock;
        BasicBlock endBlock;

        public InsnPass1Visitor(int api) {
            super(api);
            this.count = 0;
            this.endBlock = this.getEndBlock();
        }

        @Override
        public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
            this.currBlock.add(this.currInsn);
        }

        @Override
        public void visitInsn(int opcode) {
            this.currBlock.add(this.currInsn);
            if (OpInfo.ops[opcode].canReturn()) {
                CFGraph.this.addEdge(this.currBlock, this.endBlock);
                this.currBlock = CFGraph.this.getBasicBlock(CFGraph.this.basicBlocks.size());
                CFGraph.this.basicBlocks.add(this.currBlock);
            }
        }

        @Override
        public void visitIntInsn(int opcode, int operand) {
            this.currBlock.add(this.currInsn);
        }

        @Override
        public void visitVarInsn(int opcode, int var) {
            this.currBlock.add(this.currInsn);
        }

        @Override
        public void visitTypeInsn(int opcode, String type) {
            this.currBlock.add(this.currInsn);
        }

        @Override
        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            this.currBlock.add(this.currInsn);
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            this.currBlock.add(this.currInsn);
            CFGraph.this.addEdge(this.currBlock, this.endBlock);
            BasicBlock nextBlock = CFGraph.this.getBasicBlock(CFGraph.this.basicBlocks.size());
            CFGraph.this.addEdge(this.currBlock, nextBlock);
            this.currBlock = nextBlock;
            CFGraph.this.basicBlocks.add(this.currBlock);
        }

        @Override
        public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
            this.currBlock.add(this.currInsn);
            CFGraph.this.addEdge(this.currBlock, this.endBlock);
            BasicBlock nextBlock = CFGraph.this.getBasicBlock(CFGraph.this.basicBlocks.size());
            CFGraph.this.addEdge(this.currBlock, nextBlock);
            this.currBlock = nextBlock;
            CFGraph.this.basicBlocks.add(this.currBlock);
        }

        @Override
        public void visitJumpInsn(int opcode, Label label) {
            this.currBlock.add(this.currInsn);
            BasicBlock nextBlock = CFGraph.this.getBasicBlock(CFGraph.this.basicBlocks.size());
            if (!OpInfo.ops[opcode].toString().contains("goto")) {
                CFGraph.this.addEdge(this.currBlock, nextBlock);
            }
            this.currBlock = nextBlock;
            CFGraph.this.basicBlocks.add(this.currBlock);
        }

        @Override
        public void visitLabel(Label label) {
            CFGraph.this.getLabelOrder().put(label, this.count++);
            if (this.currBlock.size() > 0) {
                BasicBlock pre = this.currBlock;
                this.currBlock = CFGraph.this.getBasicBlock(CFGraph.this.basicBlocks.size());
                CFGraph.this.basicBlocks.add(this.currBlock);
                CFGraph.this.addEdge(pre, this.currBlock);
            }
            this.currBlock.add(this.currInsn);
            CFGraph.this.labelToBB.put(label, this.currBlock);
        }

        @Override
        public void visitLdcInsn(Object cst) {
            this.currBlock.add(this.currInsn);
        }

        @Override
        public void visitIincInsn(int var, int increment) {
            this.currBlock.add(this.currInsn);
        }

        @Override
        public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
            this.currBlock.add(this.currInsn);
            this.currBlock = CFGraph.this.getBasicBlock(CFGraph.this.basicBlocks.size());
            CFGraph.this.basicBlocks.add(this.currBlock);
        }

        @Override
        public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
            this.currBlock.add(this.currInsn);
            this.currBlock = CFGraph.this.getBasicBlock(CFGraph.this.basicBlocks.size());
            CFGraph.this.basicBlocks.add(this.currBlock);
        }

        @Override
        public void visitMultiANewArrayInsn(String desc, int dims) {
            this.currBlock.add(this.currInsn);
        }

        @Override
        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            this.currBlock.add(this.currInsn);
        }

        @Override
        public void visitLineNumber(int line, Label start) {
            this.currBlock.add(this.currInsn);
        }

        public void setCurrInsn(AbstractInsnNode insn) {
            this.currInsn = insn;
        }

        private BasicBlock getEndBlock() {
            BasicBlock ret = CFGraph.this.getBasicBlock(-1);
            Label l = new Label();
            ret.add(new LabelNode(l));
            CFGraph.this.labelToBB.put(l, ret);
            return ret;
        }

        @Override
        public void visitEnd() {
            CFGraph.this.basicBlocks.add(this.endBlock);
            CFGraph.this.getLabelOrder().put(((LabelNode)this.endBlock.list.get(0)).getLabel(), this.count++);
        }
    }
}

