/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.bean;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.bdware.sc.bean.SM2Verifiable;

public class ContractRequest
extends SM2Verifiable
implements Serializable,
Comparable<ContractRequest> {
    private static final long serialVersionUID = 5516141428163407726L;
    public long hasValue;
    public long gasLimit;
    public Boolean needSeq = false;
    public int seq = 0;
    public boolean withDynamicAnalysis = false;
    public boolean withEvaluatesAnalysis = false;
    public String fromContract;
    String contractID;
    String requester;
    String requesterDOI;
    String action;
    JsonElement arg;
    String requestID;
    boolean fromDebug = false;

    public static ContractRequest parse(byte[] content) {
        try {
            ObjectInputStream input = new ObjectInputStream(new ByteArrayInputStream(content));
            return (ContractRequest)input.readObject();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getContractID() {
        return this.contractID;
    }

    public ContractRequest setContractID(String id) {
        this.contractID = id;
        return this;
    }

    public String getRequester() {
        return this.requester;
    }

    public void setRequester(String requester) {
        this.requester = requester;
    }

    public String getRequesterDOI() {
        if (null == this.requesterDOI || this.requesterDOI.isEmpty()) {
            return "empty";
        }
        return this.requesterDOI;
    }

    public void setRequesterDOI(String requesterDOI) {
        this.requesterDOI = requesterDOI;
    }

    public JsonElement getArg() {
        return this.arg;
    }

    public ContractRequest setArg(String arg) {
        return this.setArg((JsonElement)new JsonPrimitive(arg));
    }

    public ContractRequest setArg(JsonElement arg) {
        this.arg = arg;
        return this;
    }

    public String getAction() {
        return this.action;
    }

    public ContractRequest setAction(String action) {
        this.action = action;
        return this;
    }

    public long getValue() {
        return this.hasValue;
    }

    public ContractRequest setValue(long hasValue) {
        this.hasValue = hasValue;
        return this;
    }

    public long getGasLimit() {
        return this.gasLimit;
    }

    public void setGasLimit(long gasLimit) {
        this.gasLimit = gasLimit;
    }

    public void setFromDebug(boolean fromDebug) {
        this.fromDebug = fromDebug;
    }

    public boolean fromDebug() {
        return this.fromDebug;
    }

    @Override
    public String getPublicKey() {
        return this.requester;
    }

    @Override
    public void setPublicKey(String pubkey) {
        this.setRequester(pubkey);
    }

    @Override
    public String getContentStr() {
        return String.format("%s|%s|%s%s|%s", this.contractID, this.action, this.parseArg(), this.gasLimit > 0L ? "|" + this.gasLimit : "", this.requester);
    }

    private String parseArg() {
        try {
            return this.arg.getAsString();
        }
        catch (Exception e) {
            return this.arg.toString();
        }
    }

    public byte[] toByte() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream bo = new ObjectOutputStream(out);
            bo.writeObject(this);
            return out.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getRequestID() {
        return this.requestID;
    }

    public void setRequestID(String str) {
        this.requestID = str;
    }

    @Override
    public int compareTo(ContractRequest cr) {
        return Integer.compare(this.seq, cr.seq);
    }
}

