/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.db;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.sc.db.MultiIndexTimeDBUtilIntf;
import org.bdware.sc.index.TimeSerialIndex;
import org.bdware.sc.util.JsonUtil;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;

public class MultiIndexTimeRocksDBUtil
implements MultiIndexTimeDBUtilIntf {
    private static final Logger LOGGER = LogManager.getLogger(MultiIndexTimeRocksDBUtil.class);
    private final Map<String, TimeSerialIndex> secondaryIndex;
    static String primaryKey = "_DB_primary_";
    public String dbPath;
    public String tableName;
    Random random = new Random();
    private RocksDB db;
    private TimeSerialIndex primaryIndex;

    public MultiIndexTimeRocksDBUtil(String path, String tableName) {
        this.secondaryIndex = new HashMap<String, TimeSerialIndex>();
        this.dbPath = path;
        this.tableName = tableName;
        this.setupDB();
    }

    private static void deleteJelck(File file) {
        if (file.exists()) {
            LOGGER.trace("delete file" + file.getAbsolutePath() + ": " + file.delete());
        }
    }

    private void setupDB() {
        File file = new File(this.dbPath + "/" + this.tableName);
        Options options = new Options();
        options.setCreateIfMissing(true);
        File lockFile = new File(file, "LOCK");
        File timeIndex = new File(this.dbPath + "/" + this.tableName + "/" + this.primaryIndex + ".timeindex");
        LOGGER.trace("create directory " + file.getAbsolutePath() + ": " + file.mkdirs());
        LOGGER.trace("delete file" + lockFile.getAbsolutePath() + ": " + lockFile.delete());
        try {
            LOGGER.debug("OpenDB:" + file.getAbsolutePath());
            this.db = RocksDB.open((Options)options, (String)file.getAbsolutePath());
        }
        catch (RocksDBException e) {
            e.printStackTrace();
        }
        this.primaryIndex = new TimeSerialIndex(timeIndex.getAbsolutePath());
        this.secondaryIndex.put(primaryKey, this.primaryIndex);
        for (File f : timeIndex.getParentFile().listFiles()) {
            if (!f.getName().endsWith(".timeindex") || f.getName().equals(timeIndex.getName())) continue;
            TimeSerialIndex index = new TimeSerialIndex(f.getAbsolutePath());
            this.secondaryIndex.putIfAbsent(f.getName().substring(0, f.getName().length() - ".timeindex".length()), index);
        }
    }

    public synchronized void put(String label, String val) {
        try {
            TimeSerialIndex index = this.getIndex(label);
            long key = this.random.nextLong();
            index.index(key);
            if (index != this.primaryIndex) {
                this.primaryIndex.index(key);
            }
            this.db.put(this.longToByte(key), val.getBytes());
        }
        catch (RocksDBException e) {
            e.printStackTrace();
        }
    }

    private long byteToLong(byte[] bytes) {
        long ret = 0L;
        for (byte aByte : bytes) {
            ret <<= 8;
            ret |= (long)aByte;
        }
        return ret;
    }

    private byte[] longToByte(long l) {
        byte[] ret = new byte[8];
        for (int i = 56; i >= 0; i -= 8) {
            byte val;
            ret[i / 8] = val = (byte)(l & 0xFFL);
            l >>= 8;
        }
        return ret;
    }

    public synchronized long queryOffset(String label, long begin) {
        TimeSerialIndex index = this.getIndex(label);
        return index.findNearest(begin);
    }

    public synchronized List<String> queryByDateAsString(String label, long begin, long end) {
        ArrayList<String> ret = new ArrayList<String>();
        TimeSerialIndex index = this.getIndex(label);
        long offset = index.findNearest(begin);
        long size = index.findNearest(end);
        int len = (int)(size - offset + 1L);
        List<Long> data = index.request(offset, len);
        for (Long l : data) {
            try {
                String t = new String(this.db.get(this.longToByte(l)));
                if (t.isEmpty()) continue;
                ret.add(t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    @Override
    public synchronized List<JsonObject> queryByDateAsJson(String label, long begin, long end) {
        ArrayList<JsonObject> ret = new ArrayList<JsonObject>();
        TimeSerialIndex index = this.getIndex(label);
        long offset = index.findNearest(begin);
        long size = index.findNearest(end);
        int len = (int)(size - offset + 1L);
        List<Long> data = index.request(offset, len);
        for (Long l : data) {
            String t = null;
            try {
                t = new String(this.db.get(this.longToByte(l)));
                if (t.isEmpty()) continue;
                JsonObject jo = JsonUtil.parseStringAsJsonObject(t);
                jo.addProperty("key", l.toString());
                ret.add(jo);
            }
            catch (Exception e) {
                LOGGER.error("parse db json error:" + t);
            }
        }
        return ret;
    }

    public long size() {
        return this.primaryIndex.size();
    }

    @Override
    public long size(String label) {
        try {
            if (label == null || label.length() == 0) {
                return this.primaryIndex.size();
            }
            if (this.secondaryIndex.containsKey(label)) {
                TimeSerialIndex index = this.getIndex(label);
                return index.size();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0L;
    }

    @Override
    public List<JsonObject> queryByOffset(String label, long offset, int count) {
        ArrayList<JsonObject> ret = new ArrayList<JsonObject>();
        TimeSerialIndex index = this.getIndex(label);
        List<TimeSerialIndex.IndexEntry> data = index.requestIndexEntry(offset, count);
        for (TimeSerialIndex.IndexEntry entry : data) {
            try {
                JsonObject jo;
                String t = new String(this.db.get(this.longToByte(entry.value)));
                if (!t.isEmpty()) {
                    try {
                        jo = JsonUtil.parseStringAsJsonObject(t);
                    }
                    catch (Exception e) {
                        jo = new JsonObject();
                        jo.addProperty("data", t);
                    }
                } else {
                    jo = new JsonObject();
                }
                jo.addProperty("key", (Number)entry.value);
                jo.addProperty("timestamp", (Number)entry.key);
                ret.add(jo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public String get(String key) {
        try {
            return new String(this.db.get(this.longToByte(Long.parseLong(key))));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private TimeSerialIndex getIndex(String label) {
        if (null == label || label.length() == 0) {
            return this.primaryIndex;
        }
        if (this.secondaryIndex.containsKey(label)) {
            return this.secondaryIndex.get(label);
        }
        TimeSerialIndex index = new TimeSerialIndex(this.dbPath + "/" + this.tableName + "/" + label + ".timeindex");
        this.secondaryIndex.putIfAbsent(label, index);
        return index;
    }

    public Map<String, Integer> querySort(String label, long date) {
        ArrayList ret = new ArrayList();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        TimeSerialIndex index = this.getIndex(label);
        long offset = index.findNearest(date);
        int len = (int)(index.size() - offset);
        List<Long> data = index.request(offset, len);
        for (Long l : data) {
            String t = null;
            try {
                t = new String(this.db.get(this.longToByte(l)));
                Map data2 = (Map)JsonUtil.fromJson(t, new TypeToken<Map<String, String>>(){}.getType());
                if (null == data2) continue;
                String action = (String)data2.get("action");
                if (map.containsKey(action)) {
                    int count = (Integer)map.get(action) + 1;
                    map.put(action, count);
                    continue;
                }
                map.put(action, 1);
            }
            catch (Exception e) {
                LOGGER.error("parse db json error:" + t);
            }
        }
        return map;
    }

    @Override
    public JsonArray countInInterval(String label, long start, long interval, long end) {
        TimeSerialIndex index = this.getIndex(label);
        long offset = index.findNearest(start);
        JsonArray array = new JsonArray();
        do {
            long offset2 = index.findNearest(start += interval);
            array.add((Number)(offset2 - offset));
            offset = offset2;
        } while (start < end);
        return array;
    }

    public void rebuildIndex(String labelField) {
        try {
            ArrayList<Long> times = new ArrayList<Long>();
            HashMap<Long, BytesPair> memoryIndex = new HashMap<Long, BytesPair>();
            RocksIterator iter = this.db.newIterator();
            iter.seekToFirst();
            while (iter.isValid()) {
                JsonObject jo = JsonUtil.parseStringAsJsonObject(new String(iter.value()));
                Long time = jo.get("date").getAsLong();
                if (time >= 0L) {
                    times.add(time);
                    memoryIndex.put(time, new BytesPair(iter.key(), iter.value()));
                }
                iter.next();
            }
            times.sort(Long::compareTo);
            for (Long time : times) {
                BytesPair dataKV = (BytesPair)memoryIndex.get(time);
                JsonObject jo = JsonUtil.fromJson(new String(dataKV.value), JsonObject.class);
                TimeSerialIndex tsi = this.getIndex(jo.get(labelField).getAsString());
                long key = this.byteToLong(dataKV.key);
                tsi.manullyIndex(time, key);
                this.primaryIndex.manullyIndex(time, key);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void close() {
        this.db.close();
    }

    public List<String> getIndexStartWith(String prefix) {
        ArrayList<String> ret = new ArrayList<String>();
        if (prefix == null) {
            prefix = "";
        }
        for (String key : this.secondaryIndex.keySet()) {
            if (!key.startsWith(prefix)) continue;
            ret.add(key);
        }
        ret.remove(primaryKey);
        return ret;
    }

    public List<String> getAllIndexKey() {
        Set<String> data = this.secondaryIndex.keySet();
        ArrayList<String> ret = new ArrayList<String>();
        ret.addAll(data);
        ret.remove(primaryKey);
        return ret;
    }

    static class BytesPair {
        byte[] key;
        byte[] value;

        BytesPair(byte[] k, byte[] v) {
            this.key = k;
            this.value = v;
        }
    }
}

