/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.visitor;

import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.misc.Interval;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.sc.node.AnnotationNode;
import org.bdware.sc.node.InterfaceNode;
import org.bdware.sc.parser.YJSParser;
import org.bdware.sc.parser.YJSParserBaseVisitor;

public class InterfaceReader
extends YJSParserBaseVisitor<InterfaceNode> {
    private static final Logger LOGGER = LogManager.getLogger(InterfaceReader.class);
    InterfaceNode node;
    String fileName;
    int regID;

    public InterfaceReader(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public InterfaceNode visitInterfaceDeclaration(YJSParser.InterfaceDeclarationContext ctx) {
        this.node = new InterfaceNode(ctx.Identifier().toString(), this.fileName);
        this.node.setLine(ctx.start.getLine());
        this.node.setPos(ctx.start.getCharPositionInLine());
        this.node.setInterval(new Interval(ctx.Interface().getSourceInterval().a, ctx.getSourceInterval().b));
        List<Object> annotations = new ArrayList();
        if (null != ctx.annotations()) {
            annotations = ctx.annotations().annotation();
        }
        for (YJSParser.AnnotationContext annotation : annotations) {
            AnnotationNode annNode = new AnnotationNode(annotation.Identifier().toString());
            if (null != annotation.annotationArgs()) {
                for (YJSParser.AnnotationLiteralContext tNode : annotation.annotationArgs().annotationLiteral()) {
                    if (null != tNode.numericLiteral()) {
                        annNode.addArg(tNode.numericLiteral().getText());
                        LOGGER.debug("------AnnotationNumericArgs:" + tNode.numericLiteral().getText());
                        continue;
                    }
                    if (null != tNode.StringLiteral()) {
                        annNode.addArg(tNode.StringLiteral().getText());
                        LOGGER.debug("------AnnotationStringArgs:" + tNode.StringLiteral().getText());
                        continue;
                    }
                    annNode.addArg(tNode.objectLiteral().getText());
                    LOGGER.debug("------AnnotationObjectArgs:" + tNode.objectLiteral().getText());
                }
            }
            this.node.addAnnotation(annNode);
        }
        return this.node;
    }
}

