package org.bdware.sc;

import org.bdware.sc.bean.Contract;
import org.bdware.sc.bean.ContractRequest;
import org.bdware.sc.node.ContractNode;

import javax.script.ScriptEngine;

public abstract class JSEngine implements ScriptEngine {

    public abstract ContractResult executeContract(ContractRequest input);

    // public abstract ContractResult loadContract(ContractNode in, boolean isInsnLimit);

    /**
     * Load a contract into contract engine
     *
     * @param contract the contract
     * @param contractNode a contract node generated by YJS compiler
     * @return whether contract is loaded successfully
     */
    public abstract ContractResult loadContract(Contract contract, ContractNode contractNode,
            boolean isInsnLim);

}
