/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.analysis.example;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.bdware.analysis.BasicBlock;
import org.bdware.analysis.BreadthFirstSearch;
import org.bdware.analysis.taint.TaintBB;
import org.bdware.analysis.taint.TaintCFG;
import org.bdware.analysis.taint.TaintConfig;
import org.bdware.analysis.taint.TaintResult;
import org.bdware.analysis.taint.TaintValue;
import org.objectweb.asm.Label;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LabelNode;

public class NaiveTaintAnalysis
extends BreadthFirstSearch<TaintResult, TaintBB> {
    TaintCFG cfg;

    public NaiveTaintAnalysis(TaintCFG cfg) {
        this.cfg = cfg;
        ArrayList<TaintBB> toAnalysis = new ArrayList<TaintBB>();
        TaintBB b = (TaintBB)cfg.getBasicBlockAt(0);
        b.preResult = new TaintResult();
        if (TaintResult.nLocals > 2) {
            b.preResult.frame.setLocal(0, new TaintValue(1, 0L));
            b.preResult.frame.setLocal(1, new TaintValue(1, 0L));
            b.preResult.frame.setLocal(2, new TaintValue(1, 1L));
        }
        b.preResult.ret = new TaintValue(1);
        TaintResult.printer.setLabelOrder(cfg.getLabelOrder());
        toAnalysis.add(b);
        b.setInList(true);
        this.setToAnalysis(toAnalysis);
        if (TaintConfig.isDebug) {
            System.out.println("===Method:" + cfg.getMethodNode().name + cfg.getMethodNode().desc);
            System.out.println("===Local:" + cfg.getMethodNode().maxLocals + " " + cfg.getMethodNode().maxStack);
        }
    }

    @Override
    public TaintResult execute(TaintBB t) {
        return t.forwardAnalysis();
    }

    @Override
    public Collection<TaintBB> getSuc(TaintBB t) {
        Set<BasicBlock> subBlock = this.cfg.getSucBlocks(t);
        System.out.println("ttlist" + t.list);
        System.out.println("subblock" + subBlock.size());
        HashSet<TaintBB> ret = new HashSet<TaintBB>();
        AbstractInsnNode insn = t.lastInsn();
        if (insn instanceof LabelNode) {
            LabelNode label = (LabelNode)insn;
            System.out.println("-----");
            System.out.println("label" + label.getLabel().toString());
            System.out.println(this.cfg.getBasicBlockByLabel((Label)label.getLabel()).blockID);
        }
        for (BasicBlock bb : subBlock) {
            System.out.println(bb.blockID);
            TaintBB ntbb = (TaintBB)bb;
            ntbb.preResult.mergeResult(t.sucResult);
            ret.add(ntbb);
        }
        return ret;
    }
}

