/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.node;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.runtime.CommonTokenStream;
import org.bdware.sc.bean.DoipOperationInfo;
import org.bdware.sc.bean.JoinInfo;
import org.bdware.sc.bean.RouteInfo;
import org.bdware.sc.event.REvent;
import org.bdware.sc.node.AnnotationNode;
import org.bdware.sc.node.ClassNode;
import org.bdware.sc.node.FunctionNode;
import org.bdware.sc.node.ImportNode;
import org.bdware.sc.node.InterfaceNode;
import org.bdware.sc.node.LogType;
import org.bdware.sc.node.Permission;
import org.bdware.sc.node.SharableNode;
import org.bdware.sc.node.YjsType;
import org.bdware.sc.util.JsonUtil;

public class ContractNode {
    private final List<ImportNode> imports;
    private final List<ClassNode> clzs;
    private final List<FunctionNode> functions;
    private final List<SharableNode> sharables;
    private final Map<String, FunctionNode> functionMap;
    private final Set<String> dependentContracts;
    private final Map<String, InterfaceNode> interfaceMap;
    public Map<String, REvent.REventSemantics> events;
    public Map<String, REvent.REventSemantics> logs;
    public List<AnnotationNode> annotations;
    public boolean sigRequired;
    public String memorySet;
    boolean isBundle;
    String contractName;
    List<Permission> permission;
    List<LogType> logTypes;
    YjsType yjsType;
    boolean instrumentBranch;

    public ContractNode(String name) {
        this.contractName = name;
        this.imports = new ArrayList<ImportNode>();
        this.clzs = new ArrayList<ClassNode>();
        this.functions = new ArrayList<FunctionNode>();
        this.functionMap = new HashMap<String, FunctionNode>();
        this.interfaceMap = new HashMap<String, InterfaceNode>();
        this.sharables = new ArrayList<SharableNode>();
        this.isBundle = false;
        this.events = new HashMap<String, REvent.REventSemantics>();
        this.logs = new HashMap<String, REvent.REventSemantics>();
        this.annotations = new ArrayList<AnnotationNode>();
        this.permission = new ArrayList<Permission>();
        this.instrumentBranch = false;
        this.dependentContracts = new HashSet<String>();
    }

    public void addFunction(FunctionNode function) {
        this.functionMap.put(function.functionName, function);
        this.getFunctions().add(function);
    }

    public void addInterface(InterfaceNode interfaceNode) {
        this.interfaceMap.put(interfaceNode.functionName, interfaceNode);
    }

    public void addSharable(SharableNode sharable) {
        this.getSharables().add(sharable);
    }

    public void addClass(ClassNode clzNode) {
        this.getClzs().add(clzNode);
    }

    public List<FunctionNode> getFunctions() {
        return this.functions;
    }

    public List<ClassNode> getClzs() {
        return this.clzs;
    }

    public List<SharableNode> getSharables() {
        return this.sharables;
    }

    public void initPlainText(CommonTokenStream cts) {
        for (ClassNode cn : this.clzs) {
            cn.initText(cts);
        }
        for (FunctionNode fun : this.functions) {
            fun.initTextWithCleaning(cts, fun.isExport, fun.isView());
            if (!fun.isExport && !fun.functionName.equals("onCreate")) continue;
            fun.initTextWithRequester();
        }
    }

    public int queryLine(String methodName) {
        FunctionNode cn = this.functionMap.get(methodName);
        if (null != cn) {
            return cn.getLine();
        }
        return 0;
    }

    public String getContractName() {
        return this.contractName;
    }

    public String queryFile(String methodName) {
        FunctionNode cn = this.functionMap.get(methodName);
        if (null != cn) {
            return cn.getFileName();
        }
        return "--";
    }

    public void addImportStmt(ImportNode importNode) {
        this.imports.add(importNode);
    }

    public List<ImportNode> getImports() {
        return this.imports;
    }

    public boolean isBundle() {
        return this.isBundle;
    }

    public void setIsBundle(boolean b) {
        this.isBundle = b;
    }

    public void merge(ContractNode contract) {
        this.sigRequired |= contract.sigRequired;
        this.instrumentBranch |= contract.instrumentBranch;
        this.imports.addAll(contract.getImports());
        for (FunctionNode fn : contract.functions) {
            this.functions.add(fn);
            this.functionMap.put(fn.functionName, fn);
        }
        for (InterfaceNode interfaceNode : contract.interfaceMap.values()) {
            InterfaceNode oldIntf = this.interfaceMap.get(interfaceNode.functionName);
            if (oldIntf == null) {
                this.interfaceMap.put(interfaceNode.functionName, interfaceNode);
                continue;
            }
            oldIntf.annotations.addAll(interfaceNode.annotations);
        }
        this.sharables.addAll(contract.getSharables());
        this.clzs.addAll(contract.clzs);
        this.events.putAll(contract.events);
        this.logs.putAll(contract.logs);
        if (null != contract.permission) {
            this.permission.addAll(contract.permission);
        }
        if (null != contract.annotations) {
            this.annotations.addAll(contract.annotations);
        }
        this.dependentContracts.addAll(contract.dependentContracts);
    }

    public boolean isExport(String action) {
        FunctionNode node = this.functionMap.get(action);
        return null != node && node.isExport;
    }

    public FunctionNode getFunction(String action) {
        return this.functionMap.get(action);
    }

    public Set<String> getDependentContracts() {
        return this.dependentContracts;
    }

    public void addDependentContracts(String contractName) {
        this.dependentContracts.add(contractName);
    }

    public void addEvent(String eventName, String semantics, boolean isGlobal) {
        Map<String, REvent.REventSemantics> pointer = isGlobal ? this.events : this.logs;
        try {
            pointer.put(eventName, REvent.REventSemantics.valueOf(semantics));
        }
        catch (IllegalArgumentException | NullPointerException e) {
            pointer.put(eventName, REvent.REventSemantics.AT_LEAST_ONCE);
        }
    }

    public void addAnnotation(AnnotationNode annNode) {
        this.annotations.add(annNode);
    }

    public void setLogType(List<String> args) {
        this.logTypes = new ArrayList<LogType>();
        for (String str : args) {
            this.logTypes.add(LogType.parse(str));
        }
    }

    public List<LogType> getLogTypes() {
        return this.logTypes;
    }

    public List<Permission> getPermission() {
        return this.permission;
    }

    public void setPermission(List<String> args) {
        for (String str : args) {
            this.permission.add(Permission.parse(str));
        }
    }

    public YjsType getYjsType() {
        return this.yjsType;
    }

    public boolean hasDoipModule() {
        if (this.functions != null) {
            for (FunctionNode node : this.functions) {
                if (node.getDoipOperationInfo() == null) continue;
                return true;
            }
        }
        return false;
    }

    public void setYjsType(YjsType yjsType1) {
        this.yjsType = yjsType1;
    }

    public boolean getInstrumentBranch() {
        return this.instrumentBranch;
    }

    public void setInstrumentBranch(boolean b) {
        this.instrumentBranch = b;
    }

    public void resetContractName(String name) {
        this.contractName = name;
    }

    public void maintainRouteJoinInfo(JsonObject methodRouteInfoMap, JsonObject methodJoinInfoMap, JsonObject dependentFunctions) {
        JoinInfo joinInfo;
        RouteInfo routeInfo;
        DoipOperationInfo doipOperationInfo;
        AnnotationNode doopAnnotation;
        List<FunctionNode> allFunctions = this.getFunctions();
        for (FunctionNode functionNode : allFunctions) {
            doopAnnotation = functionNode.getAnnotation("DOOP");
            doipOperationInfo = functionNode.getDoipOperationInfo();
            if (doopAnnotation == null || doipOperationInfo == null) continue;
            routeInfo = functionNode.getRouteInfo();
            joinInfo = functionNode.getJoinInfo();
            if (routeInfo != null) {
                this.packSourceFunctionAndDependentFunctions(this.getFunction(routeInfo.funcName), dependentFunctions);
                methodRouteInfoMap.add(doipOperationInfo.operationName, (JsonElement)JsonUtil.parseObjectAsJsonObject(routeInfo));
            }
            if (joinInfo == null) continue;
            this.packSourceFunctionAndDependentFunctions(this.getFunction(joinInfo.joinCountFuncName), dependentFunctions);
            this.packSourceFunctionAndDependentFunctions(this.getFunction(joinInfo.joinFuncName), dependentFunctions);
            methodJoinInfoMap.add(doipOperationInfo.operationName, (JsonElement)JsonUtil.parseObjectAsJsonObject(joinInfo));
        }
        for (InterfaceNode interfaceNode : this.interfaceMap.values()) {
            doopAnnotation = interfaceNode.getAnnotation("DOOP");
            doipOperationInfo = interfaceNode.getDoipOperationInfo();
            if (doopAnnotation == null || doipOperationInfo == null) continue;
            routeInfo = interfaceNode.getRouteInfo();
            joinInfo = interfaceNode.getJoinInfo();
            if (routeInfo != null) {
                this.packSourceFunctionAndDependentFunctions(this.getFunction(routeInfo.funcName), dependentFunctions);
                methodRouteInfoMap.add(doipOperationInfo.operationName, (JsonElement)JsonUtil.parseObjectAsJsonObject(routeInfo));
            }
            if (joinInfo == null) continue;
            this.packSourceFunctionAndDependentFunctions(this.getFunction(joinInfo.joinCountFuncName), dependentFunctions);
            this.packSourceFunctionAndDependentFunctions(this.getFunction(joinInfo.joinFuncName), dependentFunctions);
            methodJoinInfoMap.add(doipOperationInfo.operationName, (JsonElement)JsonUtil.parseObjectAsJsonObject(joinInfo));
        }
    }

    public void packSourceFunctionAndDependentFunctions(FunctionNode sourceFunctionNode, JsonObject functions) {
        if (sourceFunctionNode == null) {
            return;
        }
        functions.addProperty(sourceFunctionNode.functionName, sourceFunctionNode.plainText());
        for (String dependentFunctionName : sourceFunctionNode.getDependentFunctions()) {
            FunctionNode dependentFunctionNode = this.getFunction(dependentFunctionName);
            functions.addProperty(dependentFunctionName, dependentFunctionNode.plainText());
        }
    }

    public void mergeInterfaceAnnotationIntoFunction() {
        for (InterfaceNode node : this.interfaceMap.values()) {
            FunctionNode functionNode = this.functionMap.get(node.functionName);
            if (functionNode == null) continue;
            HashSet<String> funAnno = new HashSet<String>();
            for (AnnotationNode annotationNode : functionNode.annotations) {
                funAnno.add(annotationNode.type);
            }
            for (AnnotationNode annotationNode : node.annotations) {
                if (!funAnno.contains(annotationNode.type)) continue;
                throw new RuntimeException("duplicated annotation:" + node.functionName + " -> " + annotationNode.getType());
            }
            functionNode.annotations.addAll(node.annotations);
        }
    }

    public Collection<InterfaceNode> getInterfaces() {
        return this.interfaceMap.values();
    }
}

