/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.packer;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.sc.util.FileUtil;

public class JarPacker {
    public static final String zipFileName = "generatedlib/yjs.jar";
    private static final Logger LOGGER = LogManager.getLogger(JarPacker.class);
    ZipOutputStream outputZip;
    private String base = "";

    public static void zipTest() {
        try {
            String zipPath = "./input/office/wps.jar";
            ZipFile zf = new ZipFile(zipPath);
            FileInputStream fin = new FileInputStream(zipPath);
            ZipInputStream zin = new ZipInputStream(fin);
            ZipEntry zine = zin.getNextEntry();
            byte[] cc = new byte[1000];
            assert (zine != null);
            LOGGER.info("zin.read=" + zin.read(cc));
            ZipEntry ze = zf.getEntry(zine.getName());
            InputStream in = zf.getInputStream(ze);
            byte[] bb = new byte[1000];
            int count = in.read(bb);
            LOGGER.info("count=" + count);
            zin.close();
            zf.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void mergeZin(ZipInputStream zin, ZipOutputStream tempOut) throws IOException {
        ZipEntry ze;
        while (null != (ze = zin.getNextEntry())) {
            String entryName = ze.getName();
            byte[] b = new byte[40960];
            if (entryName.contains("MANIFEST.MF")) {
                LOGGER.info("Ignore: " + entryName);
                continue;
            }
            try {
                int count;
                tempOut.putNextEntry(new ZipEntry(ze.getName()));
                while ((count = zin.read(b)) > 0) {
                    tempOut.write(b, 0, count);
                }
                tempOut.closeEntry();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static byte[] input2byte(InputStream inStream) throws IOException {
        int rc;
        ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
        byte[] buff = new byte[100];
        while ((rc = inStream.read(buff, 0, 100)) > 0) {
            swapStream.write(buff, 0, rc);
        }
        return swapStream.toByteArray();
    }

    public static void pack(List<String> jarPaths) {
        new JarPacker().generateZip(jarPaths, zipFileName);
        LOGGER.info("finished!");
    }

    public static void main(String[] args) {
        ArrayList<String> paths = new ArrayList<String>();
        paths.add("./bin");
        new JarPacker(){
            boolean inject = false;

            @Override
            public byte[] transform(String inputFileName, byte[] arr) {
                if (!this.inject) {
                    this.inject = true;
                    this.addFile("META-INF/MANIFEST.MF", this.getMF());
                }
                return arr;
            }

            private byte[] getMF() {
                String sb = "Manifest-Version: 1.0\nMain-Class: com.yancloud.sc.SCAPI\n";
                return sb.getBytes();
            }
        }.generateZip(paths, "./generatedlib/yjs.jar");
        LOGGER.info("pack yjs.jar done!");
    }

    public void generateZip(List<String> dirs, String zipFileName) {
        int fileCount = 0;
        try {
            File zip;
            File dir = new File(FileUtil.getDir(zipFileName));
            if (!dir.exists()) {
                LOGGER.info("create directory " + dir.getAbsolutePath() + ": " + dir.mkdirs());
            }
            if (!(zip = new File(zipFileName)).exists()) {
                LOGGER.info("create file " + zip.getAbsolutePath() + ": " + zip.createNewFile());
            }
            FileOutputStream out = new FileOutputStream(zip);
            this.outputZip = new ZipOutputStream(out);
            for (String dirName : dirs) {
                File f = new File(dirName);
                File absolutef = f.getAbsoluteFile();
                this.base = absolutef.getAbsolutePath();
                fileCount += this.addToZip(absolutef);
            }
            LOGGER.info("fileCount=" + fileCount);
            this.outputZip.close();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int addToZip(File f) throws IOException {
        if (!f.isDirectory()) {
            String path = f.getAbsolutePath();
            if (this.accept(path)) {
                String className;
                if (File.separatorChar == '/') {
                    className = path.replaceAll(this.base, "").replaceAll("^/", "");
                } else {
                    className = path.substring(this.base.length() + 1);
                    className = className.replace("\\", "/");
                }
                this.addFile(className, JarPacker.input2byte(new FileInputStream(f)));
                return 1;
            }
            return 0;
        }
        int ret = 0;
        File[] files = f.listFiles();
        if (null != files) {
            for (File subFile : files) {
                ret += this.addToZip(subFile);
            }
        }
        return ret;
    }

    public boolean accept(String path) {
        return path.matches(".*class$");
    }

    public void addFile(String inputFileName, byte[] arr) {
        try {
            arr = this.transform(inputFileName, arr);
            this.outputZip.putNextEntry(new ZipEntry(inputFileName));
            this.outputZip.write(arr, 0, arr.length);
            this.outputZip.closeEntry();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public byte[] transform(String inputFileName, byte[] arr) {
        return arr;
    }
}

