/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.visitor;

import java.util.List;
import org.bdware.sc.node.ContractNode;
import org.bdware.sc.node.FunctionNode;
import org.bdware.sc.parser.YJSParser;
import org.bdware.sc.parser.YJSParserBaseVisitor;

public class FunctionDependencyVisitor
extends YJSParserBaseVisitor<FunctionNode> {
    public static String APPLY = ".apply";
    public static String CALL = ".call";
    private final ContractNode cn;
    private final FunctionNode fn;

    public FunctionDependencyVisitor(ContractNode cn, FunctionNode fn) {
        this.cn = cn;
        this.fn = fn;
    }

    @Override
    public FunctionNode visitArgumentsExpression(YJSParser.ArgumentsExpressionContext ctx) {
        List<YJSParser.SingleExpressionContext> singleExpress;
        super.visitArgumentsExpression(ctx);
        String funText = ctx.singleExpression().getText();
        if (funText.endsWith(APPLY)) {
            funText = funText.replaceAll(APPLY + "$", "");
        }
        if (funText.endsWith(CALL)) {
            funText = funText.replaceAll(CALL + "$", "");
        }
        if (this.cn.getFunction(funText) != null) {
            this.fn.addDependentFunctions(funText);
        }
        if (ctx.arguments() != null && (singleExpress = ctx.arguments().singleExpression()) != null && singleExpress.size() > 0) {
            for (YJSParser.SingleExpressionContext sin : singleExpress) {
                funText = sin.getText();
                if (this.cn.getFunction(funText) == null) continue;
                this.fn.addDependentFunctions(funText);
            }
        }
        return this.fn;
    }

    @Override
    public FunctionNode visitNewExpression(YJSParser.NewExpressionContext ctx) {
        super.visitNewExpression(ctx);
        for (FunctionNode f : this.cn.getFunctions()) {
            if (!f.functionName.equals(ctx.singleExpression().getText())) continue;
            this.fn.addDependentFunctions(f.functionName);
            break;
        }
        return this.fn;
    }
}

