/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.collections.StoredMap;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Jedion {
    private static final Logger LOGGER = LogManager.getLogger(Jedion.class);
    private EnvironmentConfig envConfig = null;
    private Environment myDbEnvironment = null;
    private DatabaseConfig dbConfig = null;
    private Database myDatabase;
    private StoredMap pendingDB = null;
    private String dbName = "yjs";

    public Jedion(String dbName) {
        this.dbName = dbName;
    }

    public void configEnvironment(File envDir) {
        this.envConfig = new EnvironmentConfig();
        this.envConfig.setAllowCreate(true);
        this.envConfig.setTransactional(true);
        this.envConfig.setReadOnly(false);
        try {
            this.myDbEnvironment = new Environment(envDir, this.envConfig);
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    public void createDatabase() {
        this.dbConfig = new DatabaseConfig();
        this.dbConfig.setAllowCreate(true);
        this.dbConfig.setTransactional(true);
        this.dbConfig.setReadOnly(false);
        try {
            this.myDatabase = this.myDbEnvironment.openDatabase(null, this.dbName, this.dbConfig);
            String CLASS_CATALOG = "java_class_catalog";
            Database catalogDatabase = this.myDbEnvironment.openDatabase(null, CLASS_CATALOG, this.dbConfig);
            StoredClassCatalog catalog = new StoredClassCatalog(catalogDatabase);
            SerialBinding keyBinding = new SerialBinding((ClassCatalog)catalog, byte[].class);
            this.pendingDB = new StoredMap(this.myDatabase, (EntryBinding)keyBinding, (EntryBinding)keyBinding, true);
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    public void writeToDatabase(String key, String value, boolean isOverwrite) {
        try {
            this.writeToDatabaseInternal(key, value, isOverwrite);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writeToDatabaseInternal(String key, String value, boolean isOverwrite) throws DatabaseException {
        DatabaseEntry databaseKey = new DatabaseEntry(key.trim().getBytes(StandardCharsets.UTF_8));
        DatabaseEntry databaseValue = new DatabaseEntry(value.trim().getBytes(StandardCharsets.UTF_8));
        OperationStatus res = null;
        TransactionConfig txConfig = new TransactionConfig();
        txConfig.setSerializableIsolation(true);
        Transaction txn = this.myDbEnvironment.beginTransaction(null, txConfig);
        res = isOverwrite ? this.myDatabase.put(txn, databaseKey, databaseValue) : this.myDatabase.putNoOverwrite(txn, databaseKey, databaseValue);
        txn.commit();
    }

    public ArrayList<String> getAllFromDatabase() throws DatabaseException {
        ArrayList<String> resultList = new ArrayList<String>();
        Transaction txn = this.myDbEnvironment.beginTransaction(null, null);
        CursorConfig cc = new CursorConfig();
        cc.setReadCommitted(true);
        Cursor myCursor = this.myDatabase.openCursor(txn, cc);
        DatabaseEntry entryKey = new DatabaseEntry();
        DatabaseEntry entryValue = new DatabaseEntry();
        if (myCursor.getFirst(entryKey, entryValue, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
            String key = new String(entryKey.getData(), StandardCharsets.UTF_8);
            resultList.add(key);
            while (myCursor.getNext(entryKey, entryValue, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                key = new String(entryKey.getData(), StandardCharsets.UTF_8);
                resultList.add(key);
            }
        }
        myCursor.close();
        txn.commit();
        return resultList;
    }

    public String readFromDatabaseOpted(String key) {
        return new String((byte[])this.pendingDB.get((Object)key.getBytes()));
    }

    public String readFromDatabase(String key) throws DatabaseException {
        DatabaseEntry databaseKey = new DatabaseEntry(key.trim().getBytes(StandardCharsets.UTF_8));
        DatabaseEntry databaseValue = new DatabaseEntry();
        TransactionConfig txConfig = new TransactionConfig();
        txConfig.setSerializableIsolation(true);
        Transaction txn = this.myDbEnvironment.beginTransaction(null, txConfig);
        OperationStatus res = this.myDatabase.get(txn, databaseKey, databaseValue, LockMode.DEFAULT);
        txn.commit();
        if (res == OperationStatus.SUCCESS) {
            byte[] retData = databaseValue.getData();
            return new String(retData, StandardCharsets.UTF_8);
        }
        return "";
    }

    public void visitAllItem(JedionVisitor visitor) {
        Cursor myCursor = null;
        ArrayList resultList = new ArrayList();
        Transaction txn = null;
        try {
            txn = this.myDbEnvironment.beginTransaction(null, null);
            CursorConfig cc = new CursorConfig();
            cc.setReadCommitted(true);
            myCursor = this.myDatabase.openCursor(txn, cc);
            DatabaseEntry foundKey = new DatabaseEntry();
            DatabaseEntry foundData = new DatabaseEntry();
            if (myCursor.getFirst(foundKey, foundData, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                String theKey = new String(foundKey.getData(), StandardCharsets.UTF_8);
                String theData = new String(foundData.getData(), StandardCharsets.UTF_8);
                visitor.visit(theKey, theData);
                while (myCursor.getNext(foundKey, foundData, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                    theKey = new String(foundKey.getData(), StandardCharsets.UTF_8);
                    theData = new String(foundData.getData(), StandardCharsets.UTF_8);
                    visitor.visit(theKey, theData);
                }
            }
            myCursor.close();
            txn.commit();
        }
        catch (Exception e) {
            try {
                if (null != txn) {
                    txn.abort();
                }
                if (myCursor != null) {
                    myCursor.close();
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public List<String> getEveryItem() {
        Cursor myCursor = null;
        ArrayList<String> resultList = new ArrayList<String>();
        Transaction txn = null;
        try {
            txn = this.myDbEnvironment.beginTransaction(null, null);
            CursorConfig cc = new CursorConfig();
            cc.setReadCommitted(true);
            myCursor = this.myDatabase.openCursor(txn, cc);
            DatabaseEntry foundKey = new DatabaseEntry();
            DatabaseEntry foundData = new DatabaseEntry();
            if (myCursor.getFirst(foundKey, foundData, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                String theKey = new String(foundKey.getData(), StandardCharsets.UTF_8);
                String theData = new String(foundData.getData(), StandardCharsets.UTF_8);
                resultList.add(theKey);
                while (myCursor.getNext(foundKey, foundData, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                    theKey = new String(foundKey.getData(), StandardCharsets.UTF_8);
                    theData = new String(foundData.getData(), StandardCharsets.UTF_8);
                    resultList.add(theKey);
                }
            }
            myCursor.close();
            txn.commit();
            return resultList;
        }
        catch (Exception e) {
            try {
                if (null != txn) {
                    txn.abort();
                }
                if (myCursor != null) {
                    myCursor.close();
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            return null;
        }
    }

    public long getCount() {
        try {
            return this.myDatabase.count();
        }
        catch (DatabaseException e) {
            return 0L;
        }
    }

    public List<KV> getEveryKeyValue() {
        LOGGER.debug("===========\u904d\u5386\u6570\u636e\u5e93" + this.dbName + "\u4e2d\u7684\u6240\u6709\u6570\u636e==========");
        Cursor myCursor = null;
        ArrayList<KV> resultList = new ArrayList<KV>();
        Transaction txn = null;
        try {
            txn = this.myDbEnvironment.beginTransaction(null, null);
            CursorConfig cc = new CursorConfig();
            cc.setReadCommitted(true);
            myCursor = this.myDatabase.openCursor(txn, cc);
            DatabaseEntry foundKey = new DatabaseEntry();
            DatabaseEntry foundData = new DatabaseEntry();
            if (myCursor.getFirst(foundKey, foundData, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                KV kv = new KV();
                kv.key = new String(foundKey.getData(), StandardCharsets.UTF_8);
                kv.value = new String(foundData.getData(), StandardCharsets.UTF_8);
                resultList.add(kv);
                while (myCursor.getNext(foundKey, foundData, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                    kv = new KV();
                    kv.key = new String(foundKey.getData(), StandardCharsets.UTF_8);
                    kv.value = new String(foundData.getData(), StandardCharsets.UTF_8);
                    resultList.add(kv);
                }
            }
            myCursor.close();
            txn.commit();
            LOGGER.debug("getEveryKeyValue, size:" + resultList.size());
            return resultList;
        }
        catch (Exception e) {
            try {
                if (null != txn) {
                    txn.abort();
                }
                if (myCursor != null) {
                    myCursor.close();
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            return null;
        }
    }

    public void deleteFromDatabase(String key) throws DatabaseException {
        TransactionConfig txConfig = new TransactionConfig();
        txConfig.setSerializableIsolation(true);
        Transaction txn = this.myDbEnvironment.beginTransaction(null, txConfig);
        DatabaseEntry databaseKey = new DatabaseEntry(key.trim().getBytes(StandardCharsets.UTF_8));
        OperationStatus res = this.myDatabase.delete(txn, databaseKey);
        txn.commit();
    }

    public void otherMethod() throws DatabaseException {
        String databaseName = this.myDatabase.getDatabaseName();
        LOGGER.debug("databaseName :" + databaseName);
        Environment env = this.myDatabase.getEnvironment();
        LOGGER.debug((Object)env);
        LOGGER.debug((Object)this.myDbEnvironment.getDatabaseNames());
        env.renameDatabase(null, databaseName, "newName");
        env.removeDatabase(null, databaseName);
        LOGGER.debug((Object)env.truncateDatabase(null, databaseName, true));
    }

    public void closeDatabase() throws DatabaseException {
        if (this.myDatabase != null) {
            this.myDatabase.close();
        }
        if (this.myDbEnvironment != null) {
            this.myDbEnvironment.cleanLog();
            this.myDbEnvironment.close();
        }
    }

    public static class KV {
        public String key;
        public String value;
    }

    public static abstract class JedionVisitor {
        public abstract void visit(String var1, String var2);
    }
}

