/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.index;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LenVarTimeSerialIndex {
    private static final Logger LOGGER = LogManager.getLogger(LenVarTimeSerialIndex.class);
    RandomAccessFile file;
    int dataSize = 20;
    long fileSize = 0L;
    byte[] dateBuff = new byte[8];

    public LenVarTimeSerialIndex(String fileName, int dataSize) {
        try {
            File f = new File(fileName);
            File parent = f.getParentFile();
            if (!parent.exists()) {
                LOGGER.trace("create directory " + parent.getAbsolutePath() + ": " + parent.mkdirs());
            }
            if (!f.exists()) {
                LOGGER.trace("create file " + f.getAbsolutePath() + ": " + f.createNewFile());
            }
            this.file = new RandomAccessFile(f, "rw");
            this.dataSize = dataSize;
            this.fileSize = this.file.length() / ((long)dataSize + 8L);
            this.file.seek(this.fileSize * ((long)dataSize + 8L));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void finalize() {
        try {
            this.file.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void seek(int pos) {
        try {
            this.file.seek(pos);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public synchronized void manullyIndex(long date, byte[] hash) {
        try {
            this.checkData(hash);
            ++this.fileSize;
            for (int i = 0; i < 8; ++i) {
                this.dateBuff[i] = (byte)(date >> 56 - i * 8 & 0xFFL);
            }
            this.file.write(this.dateBuff);
            this.file.write(hash);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void checkData(byte[] hash) {
        if (hash == null || hash.length != this.dataSize) {
            throw new IllegalArgumentException("unsupported data size:" + (null == hash ? "null" : Integer.valueOf(hash.length)));
        }
    }

    public synchronized long index(byte[] hash) {
        long ret = 0L;
        try {
            this.checkData(hash);
            ++this.fileSize;
            ret = System.currentTimeMillis();
            for (int i = 0; i < 8; ++i) {
                this.dateBuff[i] = (byte)(ret >> 56 - i * 8 & 0xFFL);
            }
            this.file.write(this.dateBuff);
            this.file.write(hash);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<byte[]> request(long offset, int len) {
        ArrayList<byte[]> ret = new ArrayList<byte[]>();
        if (offset < 0L) {
            offset = 0L;
        }
        if (offset < this.fileSize) {
            long pos = 0L;
            try {
                pos = this.file.getFilePointer();
                this.file.seek(offset * ((long)this.dataSize + 8L));
                while (offset < this.fileSize && len > 0) {
                    byte[] data = new byte[this.dataSize + 8];
                    this.file.read(data);
                    ret.add(data);
                    ++offset;
                    --len;
                }
                this.file.seek(pos);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    this.file.seek(pos);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return ret;
        }
        return new ArrayList<byte[]>();
    }

    public long size() {
        return this.fileSize;
    }

    public synchronized List<byte[]> requestLast(int count) {
        long offset = this.fileSize - (long)count;
        return this.request(offset, count);
    }
}

