/*
 * Decompiled with CFR 0.152.
 */
package org.bdware.sc.visitor;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.TerminalNodeImpl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bdware.sc.node.AnnotationNode;
import org.bdware.sc.node.FunctionNode;
import org.bdware.sc.node.Op;
import org.bdware.sc.node.StmtNode;
import org.bdware.sc.node.stmt.BranchStmt;
import org.bdware.sc.node.stmt.GotoStmt;
import org.bdware.sc.node.stmt.LabelStmt;
import org.bdware.sc.node.stmt.Stmt1N;
import org.bdware.sc.node.stmt.Stmt2N;
import org.bdware.sc.parser.YJSParser;
import org.bdware.sc.parser.YJSParserBaseVisitor;

public class FunctionReader
extends YJSParserBaseVisitor<FunctionNode> {
    private static final Logger LOGGER = LogManager.getLogger(FunctionReader.class);
    FunctionNode node;
    Stack<BlockInterval> blockStack;
    String fileName;
    int regID;

    public FunctionReader(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public FunctionNode visitMethodDefinition(YJSParser.MethodDefinitionContext ctx) {
        this.node = new FunctionNode(ctx.propertyName().identifierName().getText(), this.fileName);
        this.blockStack = new Stack();
        this.regID = 0;
        this.initParams(ctx.formalParameterList());
        this.initFunctionBody(ctx.functionBody());
        this.node.setLine(ctx.start.getLine());
        this.node.setPos(ctx.start.getCharPositionInLine());
        this.node.setInterval(ctx.getSourceInterval());
        return this.node;
    }

    @Override
    public FunctionNode visitFunctionDeclaration(YJSParser.FunctionDeclarationContext ctx) {
        this.node = new FunctionNode(ctx.Identifier().toString(), this.fileName);
        this.node.setIsExport(null != ctx.Export());
        this.node.setView(null != ctx.View());
        this.blockStack = new Stack();
        this.initParams(ctx.formalParameterList());
        this.initFunctionBody(ctx.functionBody());
        this.node.setLine(ctx.start.getLine());
        this.node.setPos(ctx.start.getCharPositionInLine());
        this.node.setInterval(new Interval(ctx.Function().getSourceInterval().a, ctx.getSourceInterval().b));
        List<Object> annotations = new ArrayList();
        if (null != ctx.annotations()) {
            annotations = ctx.annotations().annotation();
        }
        for (YJSParser.AnnotationContext annotation : annotations) {
            AnnotationNode annNode = new AnnotationNode(annotation.Identifier().toString());
            if (annNode.getType().equals("Mask")) {
                this.node.setIsMask(true);
            }
            if (null != annotation.annotationArgs()) {
                for (YJSParser.AnnotationLiteralContext tNode : annotation.annotationArgs().annotationLiteral()) {
                    if (null != tNode.numericLiteral()) {
                        annNode.addArg(tNode.numericLiteral().getText());
                        LOGGER.debug("------AnnotationNumericArgs:" + tNode.numericLiteral().getText());
                        continue;
                    }
                    if (null != tNode.StringLiteral()) {
                        annNode.addArg(tNode.StringLiteral().getText());
                        LOGGER.debug("------AnnotationStringArgs:" + tNode.StringLiteral().getText());
                        continue;
                    }
                    annNode.addArg(tNode.objectLiteral().getText());
                    LOGGER.debug("------AnnotationObjectArgs:" + tNode.objectLiteral().getText());
                }
            }
            this.node.addAnnotation(annNode);
        }
        return this.node;
    }

    private void initFunctionBody(YJSParser.FunctionBodyContext functionBody) {
        if (null == functionBody || null == functionBody.sourceElements()) {
            return;
        }
        List<YJSParser.SourceElementContext> sourceElements = functionBody.sourceElements().sourceElement();
        if (null != sourceElements) {
            for (YJSParser.SourceElementContext ctx : sourceElements) {
                YJSParser.StatementContext stmt = ctx.statement();
                this.visitStatement(stmt);
            }
        }
    }

    private void expandStmt(FunctionNode node, YJSParser.StatementContext stmt) {
        stmt.accept(this);
        if (null != stmt.block()) {
            YJSParser.StatementListContext list = stmt.block().statementList();
            for (YJSParser.StatementContext ctx : list.statement()) {
                this.expandStmt(node, ctx);
            }
        }
    }

    private void initParams(YJSParser.FormalParameterListContext argList) {
        if (null == argList) {
            return;
        }
        List<YJSParser.FormalParameterArgContext> args = argList.formalParameterArg();
        for (YJSParser.FormalParameterArgContext arg : args) {
            this.node.addArg(arg.Identifier().toString());
        }
    }

    @Override
    public FunctionNode visitBlock(YJSParser.BlockContext ctx) {
        LabelStmt start = new LabelStmt();
        start.setLineAndPos(ctx.start);
        LabelStmt end = new LabelStmt();
        end.setLineAndPos(ctx.stop);
        this.node.addStmt(start);
        this.blockStack.push(new BlockInterval(start, end));
        if (null != ctx.statementList()) {
            ctx.statementList().accept(this);
        }
        this.node.addStmt(end);
        this.blockStack.pop();
        return this.node;
    }

    @Override
    public FunctionNode visitVariableStatement(YJSParser.VariableStatementContext ctx) {
        List<YJSParser.VariableDeclarationContext> list = ctx.variableDeclarationList().variableDeclaration();
        for (YJSParser.VariableDeclarationContext varCtx : list) {
            varCtx.accept(this);
        }
        return this.node;
    }

    @Override
    public FunctionNode visitVariableDeclaration(YJSParser.VariableDeclarationContext ctx) {
        Stmt2N stmt = new Stmt2N(Op.Move);
        stmt.setLineAndPos(ctx.start);
        stmt.setTo(ctx.Identifier().toString());
        if (null != ctx.singleExpression()) {
            this.node.addStmts(this.parseSingleExpression(ctx.singleExpression()));
            stmt.setFrom("Reg" + (this.regID - 1));
        } else {
            stmt.setFrom("undefined");
            this.node.addStmt(stmt);
        }
        return this.node;
    }

    @Override
    public FunctionNode visitEmptyStatement(YJSParser.EmptyStatementContext ctx) {
        return this.node;
    }

    @Override
    public FunctionNode visitExpressionStatement(YJSParser.ExpressionStatementContext ctx) {
        List<YJSParser.SingleExpressionContext> list = ctx.expressionSequence().singleExpression();
        for (YJSParser.SingleExpressionContext expression : list) {
            this.node.addStmts(this.parseSingleExpression(expression));
        }
        return this.node;
    }

    @Override
    public FunctionNode visitIfStatement(YJSParser.IfStatementContext ctx) {
        BranchStmt stmt = new BranchStmt();
        LabelStmt start = new LabelStmt();
        LabelStmt end = new LabelStmt();
        List<StmtNode> l = this.parseExpressionSequence(ctx.expressionSequence());
        this.node.addStmts(l);
        stmt.setReg("Reg" + (this.regID - 1));
        stmt.setTarget(end);
        this.node.addStmt(stmt);
        this.node.addStmt(start);
        List<YJSParser.StatementContext> subBlock = ctx.statement();
        this.visitStatement(subBlock.get(0));
        this.node.addStmt(end);
        if (null != ctx.Else()) {
            GotoStmt gotoStmt = new GotoStmt();
            gotoStmt.setTarget(end);
            gotoStmt.setLineAndPos(subBlock.get((int)1).start);
            this.node.addStmt(gotoStmt);
            this.visitStatement(subBlock.get(1));
        }
        this.node.addStmt(end);
        return this.node;
    }

    @Override
    public FunctionNode visitForStatement(YJSParser.ForStatementContext ctx) {
        YJSParser.ExpressionSequenceContext ifPart;
        YJSParser.ExpressionSequenceContext prePart;
        int order = 2;
        int index = 0;
        if (ctx.getChild(order) instanceof TerminalNodeImpl && ctx.getChild(order).toString().equals(";")) {
            prePart = null;
            ++order;
        } else {
            prePart = ctx.expressionSequence(index);
            order += 2;
            ++index;
        }
        if (ctx.getChild(order) instanceof TerminalNodeImpl && ctx.getChild(order).toString().equals(";")) {
            ifPart = null;
            ++order;
        } else {
            order += 2;
            ifPart = ctx.expressionSequence(index);
            ++index;
        }
        YJSParser.ExpressionSequenceContext tailPart = ctx.getChild(order) instanceof TerminalNodeImpl && ctx.getChild(order).toString().equals(")") ? null : ctx.expressionSequence(index);
        LabelStmt start = new LabelStmt();
        start.setLineAndPos(ctx.start);
        LabelStmt end = new LabelStmt();
        end.setLineAndPos(ctx.stop);
        LabelStmt target = new LabelStmt();
        target.setLineAndPos(ctx.start);
        if (null != prePart) {
            prePart.accept(this);
        }
        this.node.addStmt(start.setLineAndPos(ctx.start));
        this.node.addStmt(new GotoStmt().setTarget(target).setLineAndPos(ctx.start));
        if (null != tailPart) {
            tailPart.accept(this);
        }
        this.node.addStmt(target);
        if (null != ifPart) {
            ifPart.accept(this);
            this.node.addStmt(new BranchStmt().setReg("Reg" + (this.regID - 1)).setTarget(end).setLineAndPos(ctx.start));
        }
        this.blockStack.push(new BlockInterval(start, end));
        this.visitStatement(ctx.statement());
        this.blockStack.pop();
        this.node.addStmt(new GotoStmt().setTarget(start).setLineAndPos(ctx.start));
        this.node.addStmt(end);
        return this.node;
    }

    @Override
    public FunctionNode visitContinueStatement(YJSParser.ContinueStatementContext ctx) {
        GotoStmt stmt = new GotoStmt();
        stmt.setLineAndPos(ctx.start);
        stmt.setTarget(this.blockStack.peek().start);
        this.node.addStmt(stmt);
        return this.node;
    }

    @Override
    public FunctionNode visitBreakStatement(YJSParser.BreakStatementContext ctx) {
        GotoStmt stmt = new GotoStmt();
        stmt.setLineAndPos(ctx.start);
        stmt.setTarget(this.blockStack.peek().end);
        this.node.addStmt(stmt);
        return this.node;
    }

    @Override
    public FunctionNode visitReturnStatement(YJSParser.ReturnStatementContext ctx) {
        this.node.addStmts(this.parseExpressionSequence(ctx.expressionSequence()));
        if (null == ctx.expressionSequence()) {
            this.node.addStmt(new Stmt1N(Op.Return, null).setLineAndPos(ctx.start));
        } else {
            this.node.addStmt(new Stmt1N(Op.Return, "Reg" + (this.regID - 1)).setLineAndPos(ctx.start));
        }
        return this.node;
    }

    @Override
    public FunctionNode visitSwitchStatement(YJSParser.SwitchStatementContext ctx) {
        return null;
    }

    private List<StmtNode> parseExpressionSequence(YJSParser.ExpressionSequenceContext expressionSequence) {
        ArrayList<StmtNode> ret = new ArrayList<StmtNode>();
        for (YJSParser.SingleExpressionContext singleExpression : expressionSequence.singleExpression()) {
            ret.addAll(this.parseSingleExpression(singleExpression));
        }
        return ret;
    }

    private List<StmtNode> parseSingleExpression(YJSParser.SingleExpressionContext singleExpression) {
        ArrayList<StmtNode> ret = new ArrayList<StmtNode>();
        ret.add(new Stmt1N(Op.STUB, "Reg" + this.regID++).setLineAndPos(singleExpression.start));
        return ret;
    }

    static class BlockInterval {
        LabelStmt start;
        LabelStmt end;

        public BlockInterval(LabelStmt s, LabelStmt e) {
            this.start = s;
            this.end = e;
        }
    }
}

